/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.food;

import net.minecraft.item.ItemStack;

import forestry.api.food.IBeverageEffect;

/**
 * describes the itemstacks required to achieve a certain effect.
 */
public class InfuserMixture {
	private final int meta;
	private final ItemStack[] ingredients;
	private final IBeverageEffect effect;

	public InfuserMixture(int meta, ItemStack ingredient, IBeverageEffect effect) {
		this(meta, new ItemStack[]{ingredient}, effect);
	}

	public InfuserMixture(int meta, ItemStack ingredients[], IBeverageEffect effect) {
		this.meta = meta;
		this.ingredients = ingredients;
		this.effect = effect;
	}

	public ItemStack[] getIngredients() {
		return ingredients;
	}

	public boolean isIngredient(ItemStack itemstack) {
		for (ItemStack ingredient : ingredients) {
			if (ingredient.func_77952_i() < 0 && ingredient.func_77973_b() == itemstack.func_77973_b()) {
				return true;
			} else if (ingredient.func_77952_i() >= 0 && ingredient.func_77969_a(itemstack)) {
				return true;
			}
		}

		return false;
	}

	public boolean matches(ItemStack[] res) {

		// No recipe without resource!
		if (res == null || res.length <= 0) {
			return false;
		}

		boolean matchedAll = true;

		for (ItemStack stack : ingredients) {
			boolean matched = false;
			for (ItemStack matchStack : res) {
				if (matchStack == null) {
					continue;
				}

				// Check item matching
				if (stack.func_77952_i() < 0 && stack.func_77973_b() == matchStack.func_77973_b()) {
					if (stack.field_77994_a <= matchStack.field_77994_a) {
						matched = true;
						break;
					}
				} else if (stack.func_77952_i() >= 0 && stack.func_77969_a(matchStack)) {
					if (stack.field_77994_a <= matchStack.field_77994_a) {
						matched = true;
						break;
					}
				}
			}
			if (!matched) {
				matchedAll = false;
			}
		}
		return matchedAll;

	}

	public IBeverageEffect getEffect() {
		return this.effect;
	}

	public int getMeta() {
		return meta;
	}

	public int getWeight() {
		return ingredients.length;
	}
}
