/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.core.inventory;

import java.io.IOException;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;

import forestry.core.config.Constants;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IStreamable;
import forestry.core.utils.InventoryUtil;

/**
 * With permission from Krapht.
 */
public class InventoryAdapter implements IInventoryAdapter, IStreamable {

	private final IInventory inventory;
	private boolean allowAutomation = true;

	//private boolean debug = false;

	public InventoryAdapter(int size, String name) {
		this(size, name, 64);
	}

	public InventoryAdapter(int size, String name, int stackLimit) {
		this(new InventoryPlain(size, name, stackLimit));
	}

	public InventoryAdapter(IInventory inventory) {
		this.inventory = inventory;
		configureSided();
	}

	public InventoryAdapter disableAutomation() {
		this.allowAutomation = false;
		return this;
	}

	//	public InventoryAdapter enableDebug() {
	//		this.debug = true;
	//		return this;
	//	}

	/**
	 * @return Copy of this inventory. Stacks are copies.
	 */
	public InventoryAdapter copy() {
		InventoryAdapter copy = new InventoryAdapter(inventory.func_70302_i_(), inventory.func_70005_c_(), inventory.func_70297_j_());

		for (int i = 0; i < inventory.func_70302_i_(); i++) {
			if (inventory.func_70301_a(i) != null) {
				copy.func_70299_a(i, inventory.func_70301_a(i).func_77946_l());
			}
		}

		return copy;
	}


	/* IINVENTORY */
	@Override
	public int func_70302_i_() {
		return inventory.func_70302_i_();
	}

	@Override
	public ItemStack func_70301_a(int slotId) {
		return inventory.func_70301_a(slotId);
	}

	@Override
	public ItemStack func_70298_a(int slotId, int count) {
		return inventory.func_70298_a(slotId, count);
	}

	@Override
	public void func_70299_a(int slotId, ItemStack itemstack) {
		inventory.func_70299_a(slotId, itemstack);
	}

	@Override
	public String func_70005_c_() {
		return inventory.func_70005_c_();
	}

	@Override
	public int func_70297_j_() {
		return inventory.func_70297_j_();
	}

	@Override
	public void func_70296_d() {
		inventory.func_70296_d();
	}
	
	@Override
	public ItemStack func_70304_b(int slotIndex) {
		return inventory.func_70304_b(slotIndex);
	}

	@Override
	public boolean func_70300_a(EntityPlayer entityplayer) {
		return true;
	}
	
	@Override
	public boolean func_145818_k_() {
		return false;
	}
	
	@Override
	public ITextComponent func_145748_c_() {
		return null;
	}

	@Override
	public boolean func_94041_b(int i, ItemStack itemstack) {
		return true;
	}

	@Override
	public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
		return true;
	}

	@Override
	public boolean isLocked(int slotIndex) {
		return false;
	}

	@Override
	public void func_174889_b(EntityPlayer player) {
	}

	@Override
	public void func_174886_c(EntityPlayer player) {
	}

	/* ISIDEDINVENTORY */
	private int[] slotMap;
	
	@Override
	public int[] func_180463_a(EnumFacing side) {
		if (allowAutomation) {
			return slotMap;
		}
		return Constants.SLOTS_NONE;
	}

	private void configureSided() {
		int count = func_70302_i_();
		slotMap = new int[count];
		for (int i = 0; i < count; i++) {
			slotMap[i] = i;
		}
	}

	@Override
	public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
		return func_94041_b(slot, stack);
	}

	@Override
	public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
		return false;
	}

	/* SAVING & LOADING */
	@Override
	public void readFromNBT(NBTTagCompound nbttagcompound) {
		InventoryUtil.readFromNBT(this, nbttagcompound);
	}

	@Override
	public NBTTagCompound writeToNBT(NBTTagCompound nbttagcompound) {
		InventoryUtil.writeToNBT(this, nbttagcompound);
		return nbttagcompound;
	}

	@Override
	public void writeData(DataOutputStreamForestry data) throws IOException {
		data.writeInventory(inventory);
	}

	@Override
	public void readData(DataInputStreamForestry data) throws IOException {
		data.readInventory(inventory);
	}
	
	/* FIELDS */
	@Override
	public int func_174887_a_(int id) {
		return 0;
	}
	
	@Override
	public int func_174890_g() {
		return 0;
	}
	
	@Override
	public void func_174885_b(int id, int value) {
	}
	
	@Override
	public void func_174888_l() {
	}
}
