/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.blocks;

import forestry.api.core.IModelManager;
import forestry.core.blocks.IMachineProperties;
import forestry.core.tiles.TileForestry;
import forestry.core.utils.BlockUtil;
import forestry.core.utils.ItemStackUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class MachineProperties<T extends TileForestry>
implements IMachineProperties<T> {
    @Nonnull
    private final String name;
    @Nonnull
    private final String teIdent;
    @Nonnull
    private final Class<T> teClass;
    @Nonnull
    private final AxisAlignedBB boundingBox;
    @Nullable
    private Block block;

    public MachineProperties(@Nonnull Class<T> teClass, @Nonnull String name) {
        this("forestry." + name, teClass, name, new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
    }

    public MachineProperties(@Nonnull Class<T> teClass, @Nonnull String name, @Nonnull AxisAlignedBB boundingBox) {
        this("forestry." + name, teClass, name, boundingBox);
    }

    private MachineProperties(@Nonnull String teIdent, @Nonnull Class<T> teClass, @Nonnull String name, @Nonnull AxisAlignedBB boundingBox) {
        this.teIdent = teIdent;
        this.teClass = teClass;
        this.name = name;
        this.boundingBox = boundingBox;
    }

    @Override
    public void setBlock(@Nonnull Block block) {
        this.block = block;
    }

    @Override
    @Nullable
    public Block getBlock() {
        return this.block;
    }

    @Override
    @Nonnull
    public AxisAlignedBB getBoundingBox(@Nonnull BlockPos pos, @Nonnull IBlockState state) {
        return this.boundingBox;
    }

    @Override
    @Nonnull
    public RayTraceResult collisionRayTrace(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull Vec3d startVec, @Nonnull Vec3d endVec) {
        return BlockUtil.collisionRayTrace(pos, startVec, endVec, this.boundingBox);
    }

    @Override
    public void registerTileEntity() {
        GameRegistry.registerTileEntity(this.teClass, (String)this.teIdent);
    }

    @Override
    public void registerModel(@Nonnull Item item, @Nonnull IModelManager manager) {
        String identifier = ItemStackUtil.getItemNameFromRegistry(item).func_110623_a();
        manager.registerItemModel(item, 0, identifier);
    }

    @Override
    @Nonnull
    public TileEntity createTileEntity() {
        try {
            return (TileEntity)this.teClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to instantiate tile entity of class " + this.teClass.getName(), e);
        }
    }

    @Override
    @Nonnull
    public String getTeIdent() {
        return this.teIdent;
    }

    @Override
    @Nonnull
    public Class<T> getTeClass() {
        return this.teClass;
    }

    @Nonnull
    public String func_176610_l() {
        return this.name;
    }

    @Override
    public boolean isFullCube(IBlockState state) {
        return true;
    }
}

