/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.lepidopterology.blocks;

import javax.annotation.Nonnull;
import java.util.Collections;
import java.util.List;
import java.util.Random;

import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.api.core.IStateMapperRegister;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.lepidopterology.EnumFlutterType;
import forestry.api.lepidopterology.IButterfly;
import forestry.core.proxy.Proxies;
import forestry.core.tiles.TileUtil;
import forestry.lepidopterology.blocks.property.PropertyCocoon;
import forestry.lepidopterology.genetics.alleles.AlleleButterflyCocoon;
import forestry.lepidopterology.items.ItemButterflyGE;
import forestry.lepidopterology.tiles.TileCocoon;

public class BlockCocoon extends Block implements ITileEntityProvider, IStateMapperRegister, IItemModelRegister {
	public static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(0.3125F, 0.3125F, 0.3125F, 0.6875F, 1F, 0.6875F);
	private static final PropertyCocoon COCOON = AlleleButterflyCocoon.COCOON;

	public BlockCocoon() {
		super(new MaterialCocoon());
		func_149675_a(true);
		func_149672_a(SoundType.field_185849_b);
		func_149647_a(null);
		func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(COCOON, AlleleButterflyCocoon.cocoonDefault).func_177226_a(AlleleButterflyCocoon.AGE, 0));
	}
	
	@Nonnull
	@Override
	protected BlockStateContainer func_180661_e() {
		return new BlockStateContainer(this, COCOON, AlleleButterflyCocoon.AGE);
	}
	
	@SideOnly(Side.CLIENT)
	@Override
	public IBlockState func_176221_a(@Nonnull IBlockState state, IBlockAccess world, BlockPos pos) {
		TileCocoon cocoon = TileUtil.getTile(world, pos, TileCocoon.class);
		if(cocoon != null){
			state = state.func_177226_a(COCOON, cocoon.getCaterpillar().getGenome().getCocoon()).func_177226_a(AlleleButterflyCocoon.AGE, cocoon.getAge());
		}
		return super.func_176221_a(state, world, pos);
	}
	
	@SideOnly(Side.CLIENT)
	@Override
	public void registerStateMapper() {
		Proxies.render.registerStateMapper(this, new CocoonStateMapper());
	}

	@SideOnly(Side.CLIENT)
	@Override
	public void registerModel(Item item, IModelManager manager) {
		//To delete the error message
		manager.registerItemModel(item, 0, "cocoon_late");
	}

	@Override
	public boolean func_149730_j(IBlockState state) {
		return false;
	}

	@Override
	public boolean func_149662_c(IBlockState state) {
		return false;
	}
    
	@Override
	public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
		TileCocoon tileCocoon = TileUtil.getTile(world, pos, TileCocoon.class);
		if (tileCocoon == null) {
			return;
		}

		if (tileCocoon.func_145837_r()) {
			return;
		}

		if (world.field_73012_v.nextFloat() > 0.1) {
			return;
		}
		tileCocoon.onBlockTick();
	}

	@Override
	public TileEntity func_149915_a(World worldIn, int meta) {
		return new TileCocoon(false);
	}

    @Override
	public int func_176201_c(IBlockState state){
        return 0;
    }

	@Override
	public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
		if (worldIn.func_175623_d(pos.func_177984_a())) {
			worldIn.func_175698_g(pos);
		}
    }
    
    @Override
    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
    	return Collections.emptyList();
    }

	@Override
	public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
		TileCocoon tile = TileUtil.getTile(world, pos, TileCocoon.class);
		if (tile == null) {
			return null;
		}

		IButterfly caterpillar = tile.getCaterpillar();
		int age = tile.getAge();

		ItemStack stack = ButterflyManager.butterflyRoot.getMemberStack(caterpillar, EnumFlutterType.COCOON);
		if (stack == null) {
			return null;
		}

		stack.func_77978_p().func_74768_a(ItemButterflyGE.NBT_AGE, age);

		return stack;
	}
	
	@Override
    public boolean func_149686_d(IBlockState state){
        return false;
    }

	@Override
	public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
		return BOUNDING_BOX.func_186670_a(pos);
	}

	@Override
	public AxisAlignedBB func_180646_a(IBlockState blockState, World worldIn, BlockPos pos) {
		return BOUNDING_BOX;
	}
	
	@Override
	public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
		return BOUNDING_BOX;
	}
    
}
