/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture;

import forestry.api.arboriculture.EnumVanillaWoodType;
import forestry.api.arboriculture.IWoodAccess;
import forestry.api.arboriculture.IWoodType;
import forestry.api.arboriculture.WoodBlockKind;
import forestry.arboriculture.IWoodTyped;
import forestry.arboriculture.PluginArboriculture;
import forestry.arboriculture.blocks.BlockArbDoor;
import forestry.arboriculture.blocks.BlockForestryFenceGate;
import forestry.arboriculture.blocks.BlockForestryStairs;
import forestry.arboriculture.blocks.fence.BlockForestryFence;
import forestry.arboriculture.blocks.log.BlockForestryLog;
import forestry.arboriculture.blocks.planks.BlockForestryPlanks;
import forestry.arboriculture.blocks.property.PropertyWoodType;
import forestry.arboriculture.blocks.slab.BlockForestrySlab;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockNewLog;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockWoodSlab;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class WoodAccess
implements IWoodAccess {
    private static final Map<WoodBlockKind, WoodMap> woodMaps = new EnumMap<WoodBlockKind, WoodMap>(WoodBlockKind.class);
    private static final List<IWoodType> registeredWoodTypes = new ArrayList<IWoodType>();

    public static void registerLogs(List<? extends BlockForestryLog> blocks) {
        for (BlockForestryLog blockForestryLog : blocks) {
            WoodAccess.registerWithVariants(blockForestryLog, WoodBlockKind.LOG, blockForestryLog.getVariant());
        }
    }

    public static void registerPlanks(List<? extends BlockForestryPlanks> blocks) {
        for (BlockForestryPlanks blockForestryPlanks : blocks) {
            WoodAccess.registerWithVariants(blockForestryPlanks, WoodBlockKind.PLANKS, blockForestryPlanks.getVariant());
        }
    }

    public static void registerSlabs(List<? extends BlockForestrySlab> blocks) {
        for (BlockForestrySlab blockForestrySlab : blocks) {
            WoodAccess.registerWithVariants(blockForestrySlab, WoodBlockKind.SLAB, blockForestrySlab.getVariant());
        }
    }

    public static void registerFences(List<? extends BlockForestryFence> blocks) {
        for (BlockForestryFence blockForestryFence : blocks) {
            WoodAccess.registerWithVariants(blockForestryFence, WoodBlockKind.FENCE, blockForestryFence.getVariant());
        }
    }

    public static void registerFenceGates(List<BlockForestryFenceGate> blocks) {
        for (BlockForestryFenceGate block : blocks) {
            WoodAccess.registerWithoutVariants(block, WoodBlockKind.FENCE_GATE);
        }
    }

    public static void registerStairs(List<? extends BlockForestryStairs> blocks) {
        for (BlockForestryStairs blockForestryStairs : blocks) {
            WoodAccess.registerWithoutVariants(blockForestryStairs, WoodBlockKind.STAIRS);
        }
    }

    public static void registerDoors(List<BlockArbDoor> blocks) {
        for (BlockArbDoor block : blocks) {
            WoodAccess.registerWithoutVariants(block, WoodBlockKind.DOOR);
        }
    }

    private static void registerVanilla() {
        IBlockState defaultLogState = Blocks.field_150364_r.func_176223_P();
        List<EnumVanillaWoodType> oldLogTypes = Arrays.asList(EnumVanillaWoodType.OAK, EnumVanillaWoodType.SPRUCE, EnumVanillaWoodType.BIRCH, EnumVanillaWoodType.JUNGLE);
        for (EnumVanillaWoodType woodType : oldLogTypes) {
            BlockPlanks.EnumType vanillaType = woodType.getVanillaType();
            ItemStack itemStack = new ItemStack(Blocks.field_150364_r, 1, vanillaType.func_176839_a());
            IBlockState blockState = defaultLogState.func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)vanillaType);
            WoodAccess.register(woodType, WoodBlockKind.LOG, false, blockState, itemStack);
        }
        IBlockState defaultLog2State = Blocks.field_150363_s.func_176223_P();
        List<EnumVanillaWoodType> newLogTypes = Arrays.asList(EnumVanillaWoodType.ACACIA, EnumVanillaWoodType.DARK_OAK);
        for (EnumVanillaWoodType woodType : newLogTypes) {
            BlockPlanks.EnumType vanillaType = woodType.getVanillaType();
            ItemStack itemStack = new ItemStack(Blocks.field_150363_s, 1, vanillaType.func_176839_a() - 4);
            IBlockState blockState = defaultLog2State.func_177226_a((IProperty)BlockNewLog.field_176300_b, (Comparable)vanillaType);
            WoodAccess.register(woodType, WoodBlockKind.LOG, false, blockState, itemStack);
        }
        IBlockState defaultPlanksState = Blocks.field_150344_f.func_176223_P();
        IBlockState defaultSlabState = Blocks.field_150376_bx.func_176223_P();
        for (EnumVanillaWoodType woodType : EnumVanillaWoodType.VALUES) {
            BlockPlanks.EnumType vanillaType = woodType.getVanillaType();
            ItemStack plankStack = new ItemStack(Blocks.field_150344_f, 1, vanillaType.func_176839_a());
            IBlockState plankState = defaultPlanksState.func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)vanillaType);
            WoodAccess.register(woodType, WoodBlockKind.PLANKS, false, plankState, plankStack);
            ItemStack slabStack = new ItemStack((Block)Blocks.field_150376_bx, 1, vanillaType.func_176839_a());
            IBlockState slabState = defaultSlabState.func_177226_a((IProperty)BlockWoodSlab.field_176557_b, (Comparable)vanillaType);
            WoodAccess.register(woodType, WoodBlockKind.SLAB, false, slabState, slabStack);
        }
        WoodAccess.register(EnumVanillaWoodType.OAK, WoodBlockKind.FENCE, false, Blocks.field_180407_aO.func_176223_P(), new ItemStack(Blocks.field_180407_aO));
        WoodAccess.register(EnumVanillaWoodType.SPRUCE, WoodBlockKind.FENCE, false, Blocks.field_180408_aP.func_176223_P(), new ItemStack(Blocks.field_180408_aP));
        WoodAccess.register(EnumVanillaWoodType.BIRCH, WoodBlockKind.FENCE, false, Blocks.field_180404_aQ.func_176223_P(), new ItemStack(Blocks.field_180404_aQ));
        WoodAccess.register(EnumVanillaWoodType.JUNGLE, WoodBlockKind.FENCE, false, Blocks.field_180403_aR.func_176223_P(), new ItemStack(Blocks.field_180403_aR));
        WoodAccess.register(EnumVanillaWoodType.ACACIA, WoodBlockKind.FENCE, false, Blocks.field_180405_aT.func_176223_P(), new ItemStack(Blocks.field_180405_aT));
        WoodAccess.register(EnumVanillaWoodType.DARK_OAK, WoodBlockKind.FENCE, false, Blocks.field_180406_aS.func_176223_P(), new ItemStack(Blocks.field_180406_aS));
        WoodAccess.register(EnumVanillaWoodType.OAK, WoodBlockKind.FENCE_GATE, false, Blocks.field_180390_bo.func_176223_P(), new ItemStack(Blocks.field_180390_bo));
        WoodAccess.register(EnumVanillaWoodType.SPRUCE, WoodBlockKind.FENCE_GATE, false, Blocks.field_180391_bp.func_176223_P(), new ItemStack(Blocks.field_180391_bp));
        WoodAccess.register(EnumVanillaWoodType.BIRCH, WoodBlockKind.FENCE_GATE, false, Blocks.field_180392_bq.func_176223_P(), new ItemStack(Blocks.field_180392_bq));
        WoodAccess.register(EnumVanillaWoodType.JUNGLE, WoodBlockKind.FENCE_GATE, false, Blocks.field_180386_br.func_176223_P(), new ItemStack(Blocks.field_180386_br));
        WoodAccess.register(EnumVanillaWoodType.ACACIA, WoodBlockKind.FENCE_GATE, false, Blocks.field_180387_bt.func_176223_P(), new ItemStack(Blocks.field_180387_bt));
        WoodAccess.register(EnumVanillaWoodType.DARK_OAK, WoodBlockKind.FENCE_GATE, false, Blocks.field_180385_bs.func_176223_P(), new ItemStack(Blocks.field_180385_bs));
        WoodAccess.register(EnumVanillaWoodType.OAK, WoodBlockKind.STAIRS, false, Blocks.field_150476_ad.func_176223_P(), new ItemStack(Blocks.field_150476_ad));
        WoodAccess.register(EnumVanillaWoodType.SPRUCE, WoodBlockKind.STAIRS, false, Blocks.field_150485_bF.func_176223_P(), new ItemStack(Blocks.field_150485_bF));
        WoodAccess.register(EnumVanillaWoodType.BIRCH, WoodBlockKind.STAIRS, false, Blocks.field_150487_bG.func_176223_P(), new ItemStack(Blocks.field_150487_bG));
        WoodAccess.register(EnumVanillaWoodType.JUNGLE, WoodBlockKind.STAIRS, false, Blocks.field_150481_bH.func_176223_P(), new ItemStack(Blocks.field_150481_bH));
        WoodAccess.register(EnumVanillaWoodType.ACACIA, WoodBlockKind.STAIRS, false, Blocks.field_150400_ck.func_176223_P(), new ItemStack(Blocks.field_150400_ck));
        WoodAccess.register(EnumVanillaWoodType.DARK_OAK, WoodBlockKind.STAIRS, false, Blocks.field_150401_cl.func_176223_P(), new ItemStack(Blocks.field_150401_cl));
        WoodAccess.register(EnumVanillaWoodType.OAK, WoodBlockKind.DOOR, false, Blocks.field_180413_ao.func_176223_P(), new ItemStack(Items.field_179570_aq));
        WoodAccess.register(EnumVanillaWoodType.SPRUCE, WoodBlockKind.DOOR, false, Blocks.field_180414_ap.func_176223_P(), new ItemStack(Items.field_179569_ar));
        WoodAccess.register(EnumVanillaWoodType.BIRCH, WoodBlockKind.DOOR, false, Blocks.field_180412_aq.func_176223_P(), new ItemStack(Items.field_179568_as));
        WoodAccess.register(EnumVanillaWoodType.JUNGLE, WoodBlockKind.DOOR, false, Blocks.field_180411_ar.func_176223_P(), new ItemStack(Items.field_179567_at));
        WoodAccess.register(EnumVanillaWoodType.ACACIA, WoodBlockKind.DOOR, false, Blocks.field_180410_as.func_176223_P(), new ItemStack(Items.field_179572_au));
        WoodAccess.register(EnumVanillaWoodType.DARK_OAK, WoodBlockKind.DOOR, false, Blocks.field_180409_at.func_176223_P(), new ItemStack(Items.field_179571_av));
    }

    private static <T extends Block, V extends Enum<V>> void registerWithVariants(T woodTyped, WoodBlockKind woodBlockKind, PropertyWoodType<V> property) {
        boolean fireproof = ((IWoodTyped)woodTyped).isFireproof();
        for (Enum value : property.func_177700_c()) {
            IBlockState blockState = woodTyped.func_176223_P().func_177226_a(property, (Comparable)((Object)value));
            int meta = woodTyped.func_176201_c(blockState);
            IWoodType woodType = ((IWoodTyped)woodTyped).getWoodType(meta);
            ItemStack itemStack = new ItemStack(woodTyped, 1, meta);
            if (!(woodType instanceof EnumVanillaWoodType)) {
                PluginArboriculture.proxy.registerWoodModel(woodTyped, true);
            }
            WoodAccess.register(woodType, woodBlockKind, fireproof, blockState, itemStack);
        }
    }

    private static <T extends Block> void registerWithoutVariants(T woodTyped, WoodBlockKind woodBlockKind) {
        boolean fireproof = ((IWoodTyped)woodTyped).isFireproof();
        IBlockState blockState = woodTyped.func_176223_P();
        IWoodType woodType = ((IWoodTyped)woodTyped).getWoodType(0);
        ItemStack itemStack = new ItemStack(woodTyped);
        if (!(woodType instanceof EnumVanillaWoodType)) {
            PluginArboriculture.proxy.registerWoodModel(woodTyped, false);
        }
        WoodAccess.register(woodType, woodBlockKind, fireproof, blockState, itemStack);
    }

    private static void register(IWoodType woodType, WoodBlockKind woodBlockKind, boolean fireproof, IBlockState blockState, ItemStack itemStack) {
        if (woodBlockKind == WoodBlockKind.DOOR) {
            fireproof = true;
        }
        if (itemStack == null || itemStack.func_77973_b() == null) {
            throw new NullPointerException("Invalid itemStack: " + itemStack);
        }
        WoodMap woodMap = woodMaps.get((Object)woodBlockKind);
        if (!registeredWoodTypes.contains(woodType)) {
            registeredWoodTypes.add(woodType);
        }
        woodMap.getItem(fireproof).put(woodType, itemStack);
        woodMap.getBlock(fireproof).put(woodType, blockState);
    }

    @Override
    public ItemStack getStack(IWoodType woodType, WoodBlockKind woodBlockKind, boolean fireproof) {
        WoodMap woodMap;
        ItemStack itemStack;
        if (woodBlockKind == WoodBlockKind.DOOR) {
            fireproof = true;
        }
        if ((itemStack = (woodMap = woodMaps.get((Object)woodBlockKind)).getItem(fireproof).get(woodType)) == null) {
            String errMessage = String.format("No stack found for %s %s %s", woodType, woodMap.getName(), fireproof ? "fireproof" : "non-fireproof");
            throw new IllegalStateException(errMessage);
        }
        return itemStack.func_77946_l();
    }

    @Override
    public IBlockState getBlock(IWoodType woodType, WoodBlockKind woodBlockKind, boolean fireproof) {
        WoodMap woodMap;
        IBlockState blockState;
        if (woodBlockKind == WoodBlockKind.DOOR) {
            fireproof = true;
        }
        if ((blockState = (woodMap = woodMaps.get((Object)woodBlockKind)).getBlock(fireproof).get(woodType)) == null) {
            String errMessage = String.format("No block found for %s %s %s", woodType, woodMap.getName(), fireproof ? "fireproof" : "non-fireproof");
            throw new IllegalStateException(errMessage);
        }
        return blockState;
    }

    @Override
    public List<IWoodType> getRegisteredWoodTypes() {
        return registeredWoodTypes;
    }

    static {
        for (WoodBlockKind woodBlockKind : WoodBlockKind.values()) {
            woodMaps.put(woodBlockKind, new WoodMap(woodBlockKind));
        }
        WoodAccess.registerVanilla();
    }

    private static class WoodMap {
        @Nonnull
        private final Map<IWoodType, ItemStack> normalItems = new HashMap<IWoodType, ItemStack>();
        @Nonnull
        private final Map<IWoodType, ItemStack> fireproofItems = new HashMap<IWoodType, ItemStack>();
        @Nonnull
        private final Map<IWoodType, IBlockState> normalBlocks = new HashMap<IWoodType, IBlockState>();
        @Nonnull
        private final Map<IWoodType, IBlockState> fireproofBlocks = new HashMap<IWoodType, IBlockState>();
        @Nonnull
        private final WoodBlockKind woodBlockKind;

        public WoodMap(@Nonnull WoodBlockKind woodBlockKind) {
            this.woodBlockKind = woodBlockKind;
        }

        @Nonnull
        public String getName() {
            return this.woodBlockKind.name();
        }

        @Nonnull
        public Map<IWoodType, ItemStack> getItem(boolean fireproof) {
            return fireproof ? this.fireproofItems : this.normalItems;
        }

        @Nonnull
        public Map<IWoodType, IBlockState> getBlock(boolean fireproof) {
            return fireproof ? this.fireproofBlocks : this.normalBlocks;
        }
    }
}

