/*
 * Decompiled with CFR 0.152.
 */
package forestry.api.arboriculture;

import forestry.api.arboriculture.IWoodType;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockPlanks;

public enum EnumVanillaWoodType implements IWoodType
{
    OAK(BlockPlanks.EnumType.OAK, 5),
    SPRUCE(BlockPlanks.EnumType.SPRUCE, 4),
    BIRCH(BlockPlanks.EnumType.BIRCH, 4),
    JUNGLE(BlockPlanks.EnumType.JUNGLE, 5),
    ACACIA(BlockPlanks.EnumType.ACACIA, 4),
    DARK_OAK(BlockPlanks.EnumType.DARK_OAK, 5);

    public static final EnumVanillaWoodType[] VALUES;
    private final BlockPlanks.EnumType vanillaType;
    private final int carbonization;

    public static EnumVanillaWoodType getRandom(Random random) {
        return VALUES[random.nextInt(VALUES.length)];
    }

    private EnumVanillaWoodType(BlockPlanks.EnumType vanillaType, int carbonization) {
        this.vanillaType = vanillaType;
        this.carbonization = carbonization;
    }

    public BlockPlanks.EnumType getVanillaType() {
        return this.vanillaType;
    }

    public String toString() {
        return super.toString().toLowerCase(Locale.ENGLISH);
    }

    public String func_176610_l() {
        return this.toString();
    }

    @Override
    public int getMetadata() {
        return this.ordinal();
    }

    @Nonnull
    public static EnumVanillaWoodType byMetadata(int meta) {
        if (meta < 0 || meta >= VALUES.length) {
            meta = 0;
        }
        return VALUES[meta];
    }

    @Override
    public float getHardness() {
        return 2.0f;
    }

    @Override
    public int getCarbonization() {
        return this.carbonization;
    }

    @Override
    public float getCharcoalChance(int numberOfCharcoal) {
        if (numberOfCharcoal == 3) {
            return 0.75f;
        }
        if (numberOfCharcoal == 4) {
            return 0.5f;
        }
        if (numberOfCharcoal == 5) {
            return 0.25f;
        }
        return 0.15f;
    }

    @Override
    public String getPlankTexture() {
        if (this == DARK_OAK) {
            return "blocks/planks_big_oak";
        }
        return "blocks/planks_" + this.func_176610_l();
    }

    @Override
    public String getDoorLowerTexture() {
        if (this == OAK) {
            return "blocks/door_wood_lower";
        }
        return "blocks/door_wood_lower";
    }

    @Override
    public String getDoorUpperTexture() {
        if (this == OAK) {
            return "blocks/door_wood_upper";
        }
        return "blocks/door_" + this.func_176610_l() + "_upper";
    }

    @Override
    public String getBarkTexture() {
        if (this == DARK_OAK) {
            return "blocks/log_big_oak";
        }
        return "blocks/log_" + this.func_176610_l();
    }

    @Override
    public String getHeartTexture() {
        if (this == DARK_OAK) {
            return "blocks/log_big_oak_top";
        }
        return "blocks/log_" + this.func_176610_l() + "_top";
    }

    static {
        VALUES = EnumVanillaWoodType.values();
    }
}

