/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.climate;

import forestry.api.climate.IClimateRegion;
import forestry.api.core.ForestryAPI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ClimateEventHandler {
    Map<Integer, Integer> serverTicks = new HashMap<Integer, Integer>();

    @SubscribeEvent
    public void onWorldTick(final TickEvent.WorldTickEvent event) {
        MinecraftServer server;
        World world = event.world;
        if (event.phase == TickEvent.Phase.END && (server = world.func_73046_m()) != null) {
            server.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    Integer dim = event.world.field_73011_w.getDimension();
                    if (!ClimateEventHandler.this.serverTicks.containsKey(dim)) {
                        ClimateEventHandler.this.serverTicks.put(dim, 1);
                    }
                    int ticks = ClimateEventHandler.this.serverTicks.get(dim);
                    Map<Integer, List<IClimateRegion>> regions = ForestryAPI.climateManager.getRegions();
                    if (regions != null && regions.containsKey(dim)) {
                        for (IClimateRegion region : regions.get(dim)) {
                            region.updateClimate(ticks);
                        }
                    }
                    ClimateEventHandler.this.serverTicks.put(dim, ticks + 1);
                }
            });
        }
    }
}

