/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.fluids;

import forestry.core.utils.InventoryUtil;
import forestry.core.utils.ItemStackUtil;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public final class FluidHelper {
    private FluidHelper() {
    }

    public static boolean areFluidStacksEqual(FluidStack fluidStack1, FluidStack fluidStack2) {
        if (fluidStack1 == null) {
            return fluidStack2 == null;
        }
        return fluidStack1.isFluidStackIdentical(fluidStack2);
    }

    public static boolean canAcceptFluid(World world, BlockPos pos, EnumFacing facing, FluidStack fluid) {
        IFluidHandler capability = FluidUtil.getFluidHandler((World)world, (BlockPos)pos, (EnumFacing)facing);
        if (capability != null) {
            for (IFluidTankProperties tankProperties : capability.getTankProperties()) {
                if (!tankProperties.canFillFluidType(fluid)) continue;
                return true;
            }
        }
        return false;
    }

    public static FillStatus fillContainers(IFluidHandler fluidHandler, IInventory inv, int inputSlot, int outputSlot, Fluid fluidToFill, boolean doFill) {
        return FluidHelper.fillContainers(fluidHandler, inv, inputSlot, outputSlot, fluidToFill, FluidHelper.getEmptyContainer(inv.func_70301_a(inputSlot)), doFill);
    }

    public static FillStatus fillContainers(IFluidHandler fluidHandler, IInventory inv, int inputSlot, int outputSlot, Fluid fluidToFill, ItemStack emptyStack, boolean doFill) {
        boolean moveToOutput;
        if (fluidToFill == null) {
            return FillStatus.INVALID_INPUT;
        }
        ItemStack input = inv.func_70301_a(inputSlot);
        if (input == null) {
            return FillStatus.INVALID_INPUT;
        }
        ItemStack output = inv.func_70301_a(outputSlot);
        ItemStack filled = input.func_77946_l();
        filled.field_77994_a = 1;
        if (emptyStack == null) {
            emptyStack = filled;
        }
        IFluidHandler fluidFilledHandler = FluidUtil.getFluidHandler((ItemStack)filled);
        IFluidHandler fluidEmptyHandler = FluidUtil.getFluidHandler((ItemStack)emptyStack);
        if (fluidFilledHandler == null || emptyStack != null && fluidEmptyHandler == null) {
            return FillStatus.INVALID_INPUT;
        }
        int containerEmptyCapacity = fluidEmptyHandler.fill(new FluidStack(fluidToFill, Integer.MAX_VALUE), false);
        int containerCapacity = fluidFilledHandler.fill(new FluidStack(fluidToFill, Integer.MAX_VALUE), false);
        if (containerCapacity <= 0 && containerEmptyCapacity <= 0) {
            return FillStatus.INVALID_INPUT;
        }
        FluidStack canDrain = fluidHandler.drain(new FluidStack(fluidToFill, containerCapacity), false);
        if (canDrain == null || canDrain.amount == 0) {
            return FillStatus.NO_FLUID;
        }
        if (fluidFilledHandler.fill(canDrain, true) <= 0) {
            return FillStatus.NO_FLUID;
        }
        FluidStack fluidInContainer = fluidFilledHandler.drain(Integer.MAX_VALUE, false);
        if (fluidInContainer == null) {
            return FillStatus.INVALID_INPUT;
        }
        boolean bl = moveToOutput = fluidInContainer.amount >= containerEmptyCapacity;
        if (moveToOutput ? output != null && (output.field_77994_a >= output.func_77976_d() || !InventoryUtil.isItemEqual(filled, output)) : input.field_77994_a > 1) {
            return FillStatus.NO_SPACE;
        }
        if (doFill) {
            fluidHandler.drain(canDrain, true);
            if (moveToOutput) {
                if (output == null) {
                    inv.func_70299_a(outputSlot, filled);
                } else {
                    ++output.field_77994_a;
                }
                inv.func_70298_a(inputSlot, 1);
            } else {
                inv.func_70299_a(inputSlot, filled);
            }
        }
        return FillStatus.SUCCESS;
    }

    public static boolean drainContainers(IFluidHandler fluidHandler, IInventory inv, int inputSlot) {
        ItemStack drainedItem;
        ItemStack input = inv.func_70301_a(inputSlot);
        if (input == null) {
            return false;
        }
        ItemStack drainedItemSimulated = FluidUtil.tryEmptyContainer((ItemStack)input, (IFluidHandler)fluidHandler, (int)1000, null, (boolean)false);
        if (drainedItemSimulated == null) {
            return false;
        }
        if ((input.field_77994_a == 1 || drainedItemSimulated.field_77994_a == 0) && (drainedItem = FluidUtil.tryEmptyContainer((ItemStack)input, (IFluidHandler)fluidHandler, (int)1000, null, (boolean)true)) != null) {
            if (drainedItem.field_77994_a > 0) {
                inv.func_70299_a(inputSlot, drainedItem);
            } else {
                inv.func_70298_a(inputSlot, 1);
            }
            return true;
        }
        return false;
    }

    public static FillStatus drainContainers(IFluidHandler fluidHandler, IInventory inv, int inputSlot, int outputSlot, boolean doDrain) {
        ItemStack input = inv.func_70301_a(inputSlot);
        if (input == null) {
            return FillStatus.INVALID_INPUT;
        }
        ItemStack outputStack = inv.func_70301_a(outputSlot);
        ItemStack drainedItemSimulated = FluidUtil.tryEmptyContainer((ItemStack)input, (IFluidHandler)fluidHandler, (int)1000, null, (boolean)false);
        if (drainedItemSimulated == null) {
            return FillStatus.INVALID_INPUT;
        }
        if (outputStack == null || drainedItemSimulated.field_77994_a == 0 || ItemStackUtil.isIdenticalItem(outputStack, drainedItemSimulated) && outputStack.field_77994_a + drainedItemSimulated.field_77994_a < outputStack.func_77976_d()) {
            ItemStack drainedItem;
            if (doDrain && (drainedItem = FluidUtil.tryEmptyContainer((ItemStack)input, (IFluidHandler)fluidHandler, (int)1000, null, (boolean)true)) != null) {
                if (drainedItem.field_77994_a > 0) {
                    ItemStack newStack = drainedItem.func_77946_l();
                    if (outputStack != null) {
                        newStack.field_77994_a += outputStack.field_77994_a;
                    }
                    if (FluidHelper.isFillableContainerAndEmpty(newStack)) {
                        inv.func_70299_a(outputSlot, newStack);
                        inv.func_70298_a(inputSlot, 1);
                    }
                } else {
                    inv.func_70298_a(inputSlot, 1);
                }
                return FillStatus.SUCCESS;
            }
            return FillStatus.SUCCESS;
        }
        return FillStatus.NO_SPACE;
    }

    public static boolean isFillableContainerAndEmpty(ItemStack container) {
        IFluidTankProperties[] tankProperties;
        IFluidHandler fluidHandler = FluidUtil.getFluidHandler((ItemStack)container);
        if (fluidHandler == null) {
            return false;
        }
        for (IFluidTankProperties properties : tankProperties = fluidHandler.getTankProperties()) {
            if (!properties.canFill() || properties.getCapacity() <= 0) continue;
            FluidStack contents = properties.getContents();
            if (contents == null) {
                return true;
            }
            if (contents.amount <= 0) continue;
            return false;
        }
        return false;
    }

    public static ItemStack getEmptyContainer(ItemStack container) {
        if (container == null) {
            return null;
        }
        ItemStack empty = container.func_77946_l();
        empty.field_77994_a = 1;
        IFluidHandler fluidHandler = FluidUtil.getFluidHandler((ItemStack)empty);
        if (fluidHandler == null) {
            return null;
        }
        if (fluidHandler.drain(Integer.MAX_VALUE, true) != null) {
            return empty;
        }
        return null;
    }

    public static boolean isFillableContainerWithRoom(ItemStack container) {
        IFluidTankProperties[] tankProperties;
        IFluidHandler fluidHandler = FluidUtil.getFluidHandler((ItemStack)container);
        if (fluidHandler == null) {
            return false;
        }
        for (IFluidTankProperties properties : tankProperties = fluidHandler.getTankProperties()) {
            if (!properties.canFill() || properties.getCapacity() <= 0) continue;
            FluidStack contents = properties.getContents();
            if (contents == null) {
                return true;
            }
            if (contents.amount >= properties.getCapacity()) continue;
            return true;
        }
        return false;
    }

    public static boolean isFillableEmptyContainer(ItemStack empty) {
        IFluidTankProperties[] tankProperties;
        IFluidHandler fluidHandler = FluidUtil.getFluidHandler((ItemStack)empty);
        if (fluidHandler == null) {
            return false;
        }
        for (IFluidTankProperties properties : tankProperties = fluidHandler.getTankProperties()) {
            if (!properties.canFill()) {
                return false;
            }
            FluidStack contents = properties.getContents();
            if (contents == null || contents.amount <= 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isDrainableFilledContainer(ItemStack container) {
        IFluidTankProperties[] tankProperties;
        IFluidHandler fluidHandler = FluidUtil.getFluidHandler((ItemStack)container);
        if (fluidHandler == null) {
            return false;
        }
        for (IFluidTankProperties properties : tankProperties = fluidHandler.getTankProperties()) {
            if (!properties.canDrain()) {
                return false;
            }
            FluidStack contents = properties.getContents();
            if (contents != null && contents.amount >= properties.getCapacity()) continue;
            return false;
        }
        return true;
    }

    public static ItemStack getDrainedContainer(ItemStack container, int drainAmount) {
        if (container == null) {
            return null;
        }
        if (drainAmount == 0) {
            return container;
        }
        container = container.func_77946_l();
        container.field_77994_a = 1;
        IFluidHandler fluidHandler = FluidUtil.getFluidHandler((ItemStack)container);
        if (fluidHandler == null) {
            return null;
        }
        fluidHandler.drain(drainAmount, true);
        if (container.field_77994_a <= 0) {
            return null;
        }
        return container;
    }

    public static ItemStack getFilledContainer(FluidStack liquid, ItemStack stack) {
        if (liquid == null || stack == null) {
            return null;
        }
        stack = stack.func_77946_l();
        stack.field_77994_a = 1;
        IFluidHandler fluidHandler = FluidUtil.getFluidHandler((ItemStack)stack);
        if (fluidHandler == null) {
            return null;
        }
        if (fluidHandler.fill(liquid, true) > 0) {
            return stack;
        }
        return null;
    }

    public static enum FillStatus {
        SUCCESS,
        INVALID_INPUT,
        NO_FLUID,
        NO_SPACE,
        NO_SPACE_FLUID;

    }
}

