/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.multiblock;

import com.google.common.base.Objects;
import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.CircuitSocketType;
import forestry.api.circuits.ICircuitBoard;
import forestry.api.circuits.ICircuitSocketType;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IErrorLogic;
import forestry.api.farming.FarmDirection;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmInventory;
import forestry.api.farming.IFarmListener;
import forestry.api.farming.IFarmLogic;
import forestry.api.farming.IFarmable;
import forestry.api.multiblock.IFarmComponent;
import forestry.api.multiblock.IMultiblockComponent;
import forestry.core.config.Config;
import forestry.core.errors.EnumErrorCode;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.TankManager;
import forestry.core.fluids.tanks.FilteredTank;
import forestry.core.fluids.tanks.StandardTank;
import forestry.core.inventory.FakeInventoryAdapter;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.inventory.InventoryAdapter;
import forestry.core.multiblock.IMultiblockControllerInternal;
import forestry.core.multiblock.MultiblockValidationException;
import forestry.core.multiblock.RectangularMultiblockControllerBase;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.utils.PlayerUtil;
import forestry.core.utils.TopDownBlockPosComparator;
import forestry.core.utils.Translator;
import forestry.farming.FarmHelper;
import forestry.farming.FarmTarget;
import forestry.farming.gui.IFarmLedgerDelegate;
import forestry.farming.logic.FarmLogicArboreal;
import forestry.farming.multiblock.FarmFertilizerManager;
import forestry.farming.multiblock.FarmHydrationManager;
import forestry.farming.multiblock.FarmMultiblockSizeLimits;
import forestry.farming.multiblock.IFarmControllerInternal;
import forestry.farming.multiblock.InventoryFarm;
import forestry.farming.tiles.TileFarmGearbox;
import forestry.farming.tiles.TileFarmPlain;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class FarmController
extends RectangularMultiblockControllerBase
implements IFarmControllerInternal,
ILiquidTankTile {
    private final Map<FarmDirection, List<FarmTarget>> targets = new EnumMap<FarmDirection, List<FarmTarget>>(FarmDirection.class);
    private int allowedExtent = 0;
    private IFarmLogic harvestProvider;
    private final List<ICrop> pendingCrops = new LinkedList<ICrop>();
    private final Stack<ItemStack> pendingProduce = new Stack();
    private Stage stage = Stage.CULTIVATE;
    private final Map<IFarmComponent.Active, Integer> farmActiveComponents = new HashMap<IFarmComponent.Active, Integer>();
    private final Set<IFarmListener> farmListeners = new HashSet<IFarmListener>();
    private final Map<FarmDirection, IFarmLogic> farmLogics = new EnumMap<FarmDirection, IFarmLogic>(FarmDirection.class);
    private final InventoryAdapter sockets;
    private final InventoryFarm inventory;
    private final TankManager tankManager;
    private final StandardTank resourceTank = new FilteredTank(10000).setFilters(FluidRegistry.WATER);
    private final FarmHydrationManager hydrationManager;
    private final FarmFertilizerManager fertilizerManager;
    private int noPowerTime = 0;
    private int farmWorkTicks = 0;
    private Vec3i offset;
    private Vec3i area;

    private static FarmDirection getLayoutDirection(FarmDirection farmSide) {
        switch (farmSide) {
            case NORTH: {
                return FarmDirection.WEST;
            }
            case WEST: {
                return FarmDirection.SOUTH;
            }
            case SOUTH: {
                return FarmDirection.EAST;
            }
            case EAST: {
                return FarmDirection.NORTH;
            }
        }
        return null;
    }

    public FarmController(World world) {
        super(world, FarmMultiblockSizeLimits.instance);
        this.tankManager = new TankManager(this, this.resourceTank);
        this.inventory = new InventoryFarm(this);
        this.sockets = new InventoryAdapter(1, "sockets");
        this.hydrationManager = new FarmHydrationManager(this);
        this.fertilizerManager = new FarmFertilizerManager();
        this.refreshFarmLogics();
    }

    @Override
    public IFarmLedgerDelegate getFarmLedgerDelegate() {
        return this.hydrationManager;
    }

    @Override
    @Nonnull
    public IInventoryAdapter getInternalInventory() {
        if (this.isAssembled()) {
            return this.inventory;
        }
        return FakeInventoryAdapter.instance();
    }

    @Override
    @Nonnull
    public TankManager getTankManager() {
        return this.tankManager;
    }

    @Override
    public void onAttachedPartWithMultiblockData(IMultiblockComponent part, NBTTagCompound data) {
        this.readFromNBT(data);
    }

    @Override
    protected void onBlockAdded(IMultiblockComponent newPart) {
        if (newPart instanceof IFarmComponent.Listener) {
            IFarmComponent.Listener listenerPart = (IFarmComponent.Listener)newPart;
            this.farmListeners.add(listenerPart.getFarmListener());
        }
        if (newPart instanceof IFarmComponent.Active) {
            this.farmActiveComponents.put((IFarmComponent.Active)newPart, this.worldObj.field_73012_v.nextInt(256));
        }
    }

    @Override
    protected void onBlockRemoved(IMultiblockComponent oldPart) {
        if (oldPart instanceof IFarmComponent.Listener) {
            IFarmComponent.Listener listenerPart = (IFarmComponent.Listener)oldPart;
            this.farmListeners.remove(listenerPart.getFarmListener());
        }
        if (oldPart instanceof IFarmComponent.Active) {
            this.farmActiveComponents.remove(oldPart);
        }
    }

    @Override
    protected void isMachineWhole() throws MultiblockValidationException {
        super.isMachineWhole();
        boolean hasGearbox = false;
        for (IMultiblockComponent part : this.connectedParts) {
            if (!(part instanceof TileFarmGearbox)) continue;
            hasGearbox = true;
            break;
        }
        if (!hasGearbox) {
            throw new MultiblockValidationException(Translator.translateToLocal("for.multiblock.farm.error.needGearbox"));
        }
    }

    @Override
    protected void onMachineDisassembled() {
        super.onMachineDisassembled();
        this.targets.clear();
    }

    @Override
    public void isGoodForExteriorLevel(IMultiblockComponent part, int level) throws MultiblockValidationException {
        if (level == 2 && !(part instanceof TileFarmPlain)) {
            throw new MultiblockValidationException(Translator.translateToLocal("for.multiblock.farm.error.needPlainBand"));
        }
    }

    @Override
    public void isGoodForInterior(IMultiblockComponent part) throws MultiblockValidationException {
        if (!(part instanceof TileFarmPlain)) {
            throw new MultiblockValidationException(Translator.translateToLocal("for.multiblock.farm.error.needPlainInterior"));
        }
    }

    @Override
    public void onAssimilate(IMultiblockControllerInternal assimilated) {
    }

    @Override
    public void onAssimilated(IMultiblockControllerInternal assimilator) {
    }

    @Override
    protected boolean updateServer(int tickCount) {
        this.hydrationManager.updateServer(this.worldObj, this.getTopCenterCoord());
        if (this.updateOnInterval(20)) {
            this.inventory.drainCan(this.tankManager);
        }
        boolean hasPower = false;
        for (Map.Entry<IFarmComponent.Active, Integer> entry : this.farmActiveComponents.entrySet()) {
            IFarmComponent.Active farmComponent = entry.getKey();
            if (farmComponent instanceof TileFarmGearbox) {
                hasPower |= ((TileFarmGearbox)farmComponent).getEnergyManager().getEnergyStored() > 0;
            }
            int tickOffset = entry.getValue();
            farmComponent.updateServer(tickCount + tickOffset);
        }
        if (hasPower) {
            this.noPowerTime = 0;
            this.getErrorLogic().setCondition(false, EnumErrorCode.NO_POWER);
        } else if (this.noPowerTime <= 4) {
            ++this.noPowerTime;
        } else {
            this.getErrorLogic().setCondition(true, EnumErrorCode.NO_POWER);
        }
        return true;
    }

    @Override
    protected void updateClient(int tickCount) {
        for (Map.Entry<IFarmComponent.Active, Integer> entry : this.farmActiveComponents.entrySet()) {
            IFarmComponent.Active farmComponent = entry.getKey();
            int tickOffset = entry.getValue();
            farmComponent.updateClient(tickCount + tickOffset);
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        data = super.writeToNBT(data);
        this.sockets.writeToNBT(data);
        this.hydrationManager.writeToNBT(data);
        this.tankManager.writeToNBT(data);
        this.fertilizerManager.writeToNBT(data);
        this.inventory.writeToNBT(data);
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.sockets.readFromNBT(data);
        this.hydrationManager.readFromNBT(data);
        this.tankManager.readFromNBT(data);
        this.fertilizerManager.readFromNBT(data);
        this.inventory.readFromNBT(data);
        this.refreshFarmLogics();
    }

    @Override
    public void formatDescriptionPacket(NBTTagCompound data) {
        this.sockets.writeToNBT(data);
        this.hydrationManager.writeToNBT(data);
        this.tankManager.writeToNBT(data);
        this.fertilizerManager.writeToNBT(data);
    }

    @Override
    public void decodeDescriptionPacket(NBTTagCompound data) {
        this.sockets.readFromNBT(data);
        this.hydrationManager.readFromNBT(data);
        this.tankManager.readFromNBT(data);
        this.fertilizerManager.readFromNBT(data);
        this.refreshFarmLogics();
    }

    @Override
    public BlockPos getCoordinates() {
        BlockPos coord = this.getReferenceCoord();
        return new BlockPos((Vec3i)coord);
    }

    @Override
    public void writeGuiData(DataOutputStreamForestry data) throws IOException {
        this.tankManager.writeData(data);
        this.hydrationManager.writeData(data);
        this.fertilizerManager.writeData(data);
        this.sockets.writeData(data);
    }

    @Override
    public void readGuiData(DataInputStreamForestry data) throws IOException {
        this.tankManager.readData(data);
        this.hydrationManager.readData(data);
        this.fertilizerManager.readData(data);
        this.sockets.readData(data);
        this.refreshFarmLogics();
    }

    private void refreshFarmLogics() {
        ICircuitBoard chipset;
        for (FarmDirection direction : FarmDirection.values()) {
            this.resetFarmLogic(direction);
        }
        ItemStack chip = this.sockets.func_70301_a(0);
        if (chip != null && (chipset = ChipsetManager.circuitRegistry.getCircuitBoard(chip)) != null) {
            chipset.onLoad(this);
        }
    }

    @Override
    public EnumTemperature getTemperature() {
        return EnumTemperature.getFromValue(this.getExactTemperature());
    }

    @Override
    public EnumHumidity getHumidity() {
        return EnumHumidity.getFromValue(this.getExactHumidity());
    }

    @Override
    public float getExactTemperature() {
        BlockPos coords = this.getReferenceCoord();
        return ForestryAPI.climateManager.getTemperature(this.getWorldObj(), coords);
    }

    @Override
    public float getExactHumidity() {
        BlockPos coords = this.getReferenceCoord();
        return ForestryAPI.climateManager.getHumidity(this.getWorldObj(), coords);
    }

    @Override
    public BlockPos getCoords() {
        return this.getCenterCoord();
    }

    @Override
    public Vec3i getOffset() {
        if (this.offset == null) {
            Vec3i area = this.getArea();
            this.offset = new Vec3i(-area.func_177958_n() / 2, -2, -area.func_177952_p() / 2);
        }
        return this.offset;
    }

    @Override
    public Vec3i getArea() {
        if (this.area == null) {
            this.area = new Vec3i(7 + this.allowedExtent * 2, 13, 7 + this.allowedExtent * 2);
        }
        return this.area;
    }

    @Override
    public String getUnlocalizedType() {
        return "for.multiblock.farm.type";
    }

    @Override
    public boolean doWork() {
        ++this.farmWorkTicks;
        if (this.targets.isEmpty() || this.farmWorkTicks % 20 == 0) {
            this.setUpFarmlandTargets();
        }
        IErrorLogic errorLogic = this.getErrorLogic();
        if (!this.pendingProduce.isEmpty()) {
            boolean added = this.inventory.tryAddPendingProduce(this.pendingProduce);
            errorLogic.setCondition(!added, EnumErrorCode.NO_SPACE_INVENTORY);
            return added;
        }
        boolean hasFertilizer = this.fertilizerManager.maintainFertilizer(this.inventory);
        if (errorLogic.setCondition(!hasFertilizer, EnumErrorCode.NO_FERTILIZER)) {
            return false;
        }
        if (!this.pendingCrops.isEmpty()) {
            ICrop first = this.pendingCrops.get(0);
            if (this.cullCrop(first, this.harvestProvider)) {
                this.pendingCrops.remove(0);
                return true;
            }
            return false;
        }
        FarmWorkStatus farmWorkStatus = new FarmWorkStatus();
        List<FarmDirection> farmDirections = Arrays.asList(FarmDirection.values());
        Collections.shuffle(farmDirections, this.worldObj.field_73012_v);
        for (FarmDirection farmSide : farmDirections) {
            IFarmLogic logic = this.getFarmLogic(farmSide);
            if (logic == null) continue;
            if (this.collectWindfall(logic)) {
                farmWorkStatus.didWork = true;
            }
            List<FarmTarget> farmTargets = this.targets.get((Object)farmSide);
            if (this.stage == Stage.HARVEST) {
                Collection<ICrop> harvested = FarmController.harvestTargets(this.worldObj, farmTargets, logic, this.farmListeners);
                boolean bl = farmWorkStatus.didWork = !harvested.isEmpty();
                if (!harvested.isEmpty()) {
                    this.pendingCrops.addAll(harvested);
                    Collections.sort(this.pendingCrops, TopDownICropComparator.INSTANCE);
                    this.harvestProvider = logic;
                }
            } else if (this.stage == Stage.CULTIVATE) {
                farmWorkStatus = this.cultivateTargets(farmWorkStatus, farmTargets, logic, farmSide);
            }
            if (!farmWorkStatus.didWork) continue;
            break;
        }
        if (this.stage == Stage.CULTIVATE) {
            errorLogic.setCondition(!farmWorkStatus.hasFarmland, EnumErrorCode.NO_FARMLAND);
            errorLogic.setCondition(!farmWorkStatus.hasFertilizer, EnumErrorCode.NO_FERTILIZER);
            errorLogic.setCondition(!farmWorkStatus.hasLiquid, EnumErrorCode.NO_LIQUID_FARM);
        }
        this.stage = this.stage.next();
        return farmWorkStatus.didWork;
    }

    private void setUpFarmlandTargets() {
        BlockPos targetStart = this.getCoords();
        BlockPos max = this.getMaximumCoord();
        BlockPos min = this.getMinimumCoord();
        int sizeNorthSouth = Math.abs(max.func_177952_p() - min.func_177952_p()) + 1;
        int sizeEastWest = Math.abs(max.func_177958_n() - min.func_177958_n()) + 1;
        this.allowedExtent = Math.max(sizeNorthSouth, sizeEastWest) * Config.farmSize + 1;
        FarmController.createTargets(this.worldObj, this.targets, targetStart, this.allowedExtent, sizeNorthSouth, sizeEastWest, min, max);
        FarmController.setExtents(this.worldObj, this.targets);
    }

    private static void createTargets(World world, Map<FarmDirection, List<FarmTarget>> targets, BlockPos targetStart, int allowedExtent, int farmSizeNorthSouth, int farmSizeEastWest, BlockPos minFarmCoord, BlockPos maxFarmCoord) {
        for (FarmDirection farmSide : FarmDirection.values()) {
            IBlockState blockState;
            BlockPos groundLocation;
            int farmWidth = farmSide == FarmDirection.NORTH || farmSide == FarmDirection.SOUTH ? farmSizeEastWest : farmSizeNorthSouth;
            int targetMaxLimit = allowedExtent + farmWidth;
            FarmDirection layoutDirection = FarmController.getLayoutDirection(farmSide);
            BlockPos targetLocation = FarmHelper.getFarmMultiblockCorner(targetStart, farmSide, layoutDirection, minFarmCoord, maxFarmCoord);
            BlockPos firstLocation = targetLocation.func_177972_a(farmSide.getFacing());
            BlockPos firstGroundPosition = FarmController.getGroundPosition(world, firstLocation);
            if (firstGroundPosition == null) continue;
            int groundHeight = firstGroundPosition.func_177956_o();
            ArrayList<FarmTarget> farmSideTargets = new ArrayList<FarmTarget>();
            for (int i = 0; i < allowedExtent && world.func_175667_e(groundLocation = new BlockPos((targetLocation = targetLocation.func_177972_a(farmSide.getFacing())).func_177958_n(), groundHeight, targetLocation.func_177952_p())) && FarmHelper.bricks.contains((Object)(blockState = world.func_180495_p(groundLocation)).func_177230_c()); ++i) {
                int targetLimit = targetMaxLimit;
                if (!Config.squareFarms) {
                    targetLimit = targetMaxLimit - i - 1;
                }
                FarmTarget target = new FarmTarget(targetLocation, layoutDirection, targetLimit);
                farmSideTargets.add(target);
            }
            targets.put(farmSide, farmSideTargets);
        }
    }

    @Nullable
    private static BlockPos getGroundPosition(World world, BlockPos targetPosition) {
        if (!world.func_175667_e(targetPosition)) {
            return null;
        }
        for (int yOffset = 2; yOffset > -4; --yOffset) {
            BlockPos position = targetPosition.func_177982_a(0, yOffset, 0);
            IBlockState blockState = world.func_180495_p(position);
            if (!FarmHelper.bricks.contains((Object)blockState.func_177230_c())) continue;
            return position;
        }
        return null;
    }

    private static boolean isCycleCanceledByListeners(IFarmLogic logic, FarmDirection direction, Iterable<IFarmListener> farmListeners) {
        for (IFarmListener listener : farmListeners) {
            if (!listener.cancelTask(logic, direction)) continue;
            return true;
        }
        return false;
    }

    private static void setExtents(World worldObj, Map<FarmDirection, List<FarmTarget>> targets) {
        for (List<FarmTarget> targetsList : targets.values()) {
            if (targetsList.isEmpty()) continue;
            BlockPos groundPosition = FarmController.getGroundPosition(worldObj, targetsList.get(0).getStart());
            for (FarmTarget target : targetsList) {
                target.setExtentAndYOffset(worldObj, groundPosition);
            }
        }
    }

    private FarmWorkStatus cultivateTargets(FarmWorkStatus farmWorkStatus, List<FarmTarget> farmTargets, IFarmLogic logic, FarmDirection farmSide) {
        boolean hasFarmland = false;
        if (farmTargets != null) {
            for (FarmTarget target : farmTargets) {
                if (target.getExtent() <= 0) continue;
                hasFarmland = true;
                farmWorkStatus.hasFarmland = true;
                break;
            }
        }
        if (hasFarmland && !FarmController.isCycleCanceledByListeners(logic, farmSide, this.farmListeners)) {
            float hydrationModifier = this.hydrationManager.getHydrationModifier();
            int fertilizerConsumption = logic.getFertilizerConsumption();
            int liquidConsumption = logic.getWaterConsumption(hydrationModifier);
            FluidStack liquid = new FluidStack(FluidRegistry.WATER, liquidConsumption);
            for (FarmTarget target : farmTargets) {
                if (!this.fertilizerManager.hasFertilizer(fertilizerConsumption)) {
                    farmWorkStatus.hasFertilizer = false;
                    continue;
                }
                if (liquid.amount > 0 && !this.hasLiquid(liquid)) {
                    farmWorkStatus.hasLiquid = false;
                    continue;
                }
                if (!FarmController.cultivateTarget(this.worldObj, this, target, logic, this.farmListeners)) continue;
                this.fertilizerManager.removeFertilizer(fertilizerConsumption);
                this.removeLiquid(liquid);
                farmWorkStatus.didWork = true;
            }
        }
        return farmWorkStatus;
    }

    private static boolean cultivateTarget(World world, IFarmHousing farmHousing, FarmTarget target, IFarmLogic logic, Iterable<IFarmListener> farmListeners) {
        BlockPos targetPosition = target.getStart().func_177982_a(0, target.getYOffset(), 0);
        if (logic.cultivate(world, farmHousing, targetPosition, target.getDirection(), target.getExtent())) {
            for (IFarmListener listener : farmListeners) {
                listener.hasCultivated(logic, targetPosition, target.getDirection(), target.getExtent());
            }
            return true;
        }
        return false;
    }

    private static Collection<ICrop> harvestTargets(World world, List<FarmTarget> farmTargets, IFarmLogic logic, Iterable<IFarmListener> farmListeners) {
        if (farmTargets != null) {
            for (FarmTarget target : farmTargets) {
                Collection<ICrop> harvested = FarmController.harvestTarget(world, target, logic, farmListeners);
                if (harvested.isEmpty()) continue;
                return harvested;
            }
        }
        return Collections.emptyList();
    }

    private static Collection<ICrop> harvestTarget(World world, FarmTarget target, IFarmLogic logic, Iterable<IFarmListener> farmListeners) {
        BlockPos pos = target.getStart().func_177982_a(0, target.getYOffset(), 0);
        Collection<ICrop> harvested = logic.harvest(world, pos, target.getDirection(), target.getExtent());
        if (harvested == null || harvested.isEmpty()) {
            return Collections.emptyList();
        }
        for (IFarmListener listener : farmListeners) {
            listener.hasScheduledHarvest(harvested, logic, pos, target.getDirection(), target.getExtent());
        }
        return harvested;
    }

    private boolean collectWindfall(IFarmLogic logic) {
        Collection<ItemStack> collected = logic.collect(this.worldObj, this);
        if (collected == null || collected.size() <= 0) {
            return false;
        }
        for (IFarmListener listener : this.farmListeners) {
            listener.hasCollected(collected, logic);
        }
        for (ItemStack produce : collected) {
            this.inventory.addProduce(produce);
            this.pendingProduce.push(produce);
        }
        return true;
    }

    private boolean cullCrop(ICrop crop, IFarmLogic provider) {
        Boolean hasFertilizer;
        for (IFarmListener listener : this.farmListeners) {
            if (!listener.beforeCropHarvest(crop)) continue;
            return true;
        }
        int fertilizerConsumption = provider.getFertilizerConsumption();
        IErrorLogic errorLogic = this.getErrorLogic();
        if (errorLogic.setCondition((hasFertilizer = Boolean.valueOf(this.fertilizerManager.hasFertilizer(fertilizerConsumption))) == false, EnumErrorCode.NO_FERTILIZER)) {
            return false;
        }
        float hydrationModifier = this.hydrationManager.getHydrationModifier();
        int waterConsumption = provider.getWaterConsumption(hydrationModifier);
        FluidStack requiredLiquid = new FluidStack(FluidRegistry.WATER, waterConsumption);
        boolean hasLiquid = requiredLiquid.amount == 0 || this.hasLiquid(requiredLiquid);
        if (errorLogic.setCondition(!hasLiquid, EnumErrorCode.NO_LIQUID_FARM)) {
            return false;
        }
        Collection<ItemStack> harvested = crop.harvest();
        if (harvested == null) {
            return true;
        }
        this.fertilizerManager.removeFertilizer(fertilizerConsumption);
        this.removeLiquid(requiredLiquid);
        for (IFarmListener listener : this.farmListeners) {
            listener.afterCropHarvest(harvested, crop);
        }
        this.inventory.stowHarvest(harvested, this.pendingProduce);
        return true;
    }

    @Override
    public int getStoredFertilizerScaled(int scale) {
        return this.fertilizerManager.getStoredFertilizerScaled(scale);
    }

    @Override
    public boolean hasLiquid(FluidStack liquid) {
        FluidStack drained = this.resourceTank.drainInternal(liquid, false);
        return FluidHelper.areFluidStacksEqual(drained, liquid);
    }

    @Override
    public void removeLiquid(FluidStack liquid) {
        this.resourceTank.drain(liquid.amount, true);
    }

    @Override
    public boolean plantGermling(IFarmable germling, World world, BlockPos pos) {
        EntityPlayer player = PlayerUtil.getPlayer(world, this.getOwnerHandler().getOwner());
        return this.inventory.plantGermling(germling, player, pos);
    }

    @Override
    public IFarmInventory getFarmInventory() {
        return this.inventory;
    }

    @Override
    public void setFarmLogic(FarmDirection direction, IFarmLogic logic) {
        if (logic == null) {
            throw new NullPointerException("logic must not be null");
        }
        this.farmLogics.put(direction, logic);
    }

    @Override
    public void resetFarmLogic(FarmDirection direction) {
        this.setFarmLogic(direction, new FarmLogicArboreal());
    }

    @Override
    public IFarmLogic getFarmLogic(FarmDirection direction) {
        return this.farmLogics.get((Object)direction);
    }

    @Override
    public int getSocketCount() {
        return this.sockets.func_70302_i_();
    }

    @Override
    public ItemStack getSocket(int slot) {
        return this.sockets.func_70301_a(slot);
    }

    @Override
    public void setSocket(int slot, ItemStack stack) {
        ICircuitBoard chipset;
        if (stack != null && !ChipsetManager.circuitRegistry.isChipset(stack)) {
            return;
        }
        if (this.sockets.func_70301_a(slot) != null && ChipsetManager.circuitRegistry.isChipset(this.sockets.func_70301_a(slot)) && (chipset = ChipsetManager.circuitRegistry.getCircuitBoard(this.sockets.func_70301_a(slot))) != null) {
            chipset.onRemoval(this);
        }
        this.sockets.func_70299_a(slot, stack);
        this.refreshFarmLogics();
        if (stack == null) {
            return;
        }
        chipset = ChipsetManager.circuitRegistry.getCircuitBoard(stack);
        if (chipset != null) {
            chipset.onInsertion(this);
        }
    }

    @Override
    public ICircuitSocketType getSocketType() {
        return CircuitSocketType.FARM;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("stage", (Object)this.stage).add("logic", (Object)this.farmLogics.toString()).toString();
    }

    private static class TopDownICropComparator
    implements Comparator<ICrop> {
        public static final TopDownICropComparator INSTANCE = new TopDownICropComparator();

        private TopDownICropComparator() {
        }

        @Override
        public int compare(ICrop o1, ICrop o2) {
            return TopDownBlockPosComparator.INSTANCE.compare(o1.getPosition(), o2.getPosition());
        }
    }

    private static class FarmWorkStatus {
        public boolean didWork = false;
        public boolean hasFarmland = false;
        public boolean hasFertilizer = true;
        public boolean hasLiquid = true;

        private FarmWorkStatus() {
        }
    }

    private static enum Stage {
        CULTIVATE,
        HARVEST;


        public Stage next() {
            if (this == CULTIVATE) {
                return HARVEST;
            }
            return CULTIVATE;
        }
    }
}

