/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.render;

import com.google.common.collect.Maps;
import forestry.core.utils.Log;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.PngSizeInfo;
import net.minecraft.client.renderer.texture.Stitcher;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;

@SideOnly(value=Side.CLIENT)
public class TextureMapForestry
extends TextureMap {
    private boolean skipFirst = true;

    public TextureMapForestry(String basePathIn) {
        super(basePathIn, null, true);
    }

    public void func_110551_a(@Nonnull IResourceManager resourceManager) throws IOException {
        this.func_110569_e();
        this.func_147631_c();
        this.func_110571_b(resourceManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void func_110571_b(@Nonnull IResourceManager resourceManager) {
        int i = Minecraft.func_71369_N();
        Stitcher stitcher = new Stitcher(i, i, 0, 0);
        this.field_94252_e.clear();
        this.field_94258_i.clear();
        ProgressManager.ProgressBar bar = ProgressManager.push((String)"Texture stitching", (int)(this.skipFirst ? 0 : this.field_110574_e.size()));
        if (!this.skipFirst) {
            for (Map.Entry entry : this.field_110574_e.entrySet()) {
                TextureAtlasSprite textureatlassprite = (TextureAtlasSprite)entry.getValue();
                ResourceLocation resourcelocation = this.getResourceLocation(textureatlassprite);
                bar.step(resourcelocation.func_110623_a());
                IResource iresource = null;
                if (textureatlassprite.hasCustomLoader(resourceManager, resourcelocation)) {
                    if (textureatlassprite.load(resourceManager, resourcelocation)) {
                        continue;
                    }
                } else {
                    try {
                        PngSizeInfo pngsizeinfo = PngSizeInfo.func_188532_a((IResource)resourceManager.func_110536_a(resourcelocation));
                        iresource = resourceManager.func_110536_a(resourcelocation);
                        boolean flag = iresource.func_110526_a("animation") != null;
                        textureatlassprite.func_188538_a(pngsizeinfo, flag);
                        IOUtils.closeQuietly((Closeable)iresource);
                    }
                    catch (RuntimeException runtimeexception) {
                        FMLClientHandler.instance().trackBrokenTexture(resourcelocation, runtimeexception.getMessage());
                        IOUtils.closeQuietly((Closeable)iresource);
                        continue;
                    }
                    catch (IOException ioexception) {
                        FMLClientHandler.instance().trackMissingTexture(resourcelocation);
                        continue;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                    finally {
                        IOUtils.closeQuietly(iresource);
                        continue;
                    }
                }
                stitcher.func_110934_a(textureatlassprite);
            }
        }
        ProgressManager.pop((ProgressManager.ProgressBar)bar);
        this.field_94249_f.func_147963_d(0);
        stitcher.func_110934_a(this.field_94249_f);
        this.skipFirst = false;
        bar = ProgressManager.push((String)"Texture creation", (int)2);
        bar.step("Stitching");
        stitcher.func_94305_f();
        Log.info("Created: {}x{} {}-atlas", stitcher.func_110935_a(), stitcher.func_110936_b(), this.field_94254_c);
        bar.step("Allocating GL texture");
        TextureUtil.func_180600_a((int)this.func_110552_b(), (int)0, (int)stitcher.func_110935_a(), (int)stitcher.func_110936_b());
        HashMap map = Maps.newHashMap((Map)this.field_110574_e);
        ProgressManager.pop((ProgressManager.ProgressBar)bar);
        bar = ProgressManager.push((String)"Texture mipmap and upload", (int)stitcher.func_94309_g().size());
        for (TextureAtlasSprite textureatlassprite1 : stitcher.func_94309_g()) {
            bar.step(textureatlassprite1.func_94215_i());
            if (textureatlassprite1 != this.field_94249_f && !this.generateMipmaps(resourceManager, textureatlassprite1)) continue;
            String s = textureatlassprite1.func_94215_i();
            map.remove(s);
            this.field_94252_e.put(s, textureatlassprite1);
            try {
                TextureUtil.func_147955_a((int[][])textureatlassprite1.func_147965_a(0), (int)textureatlassprite1.func_94211_a(), (int)textureatlassprite1.func_94216_b(), (int)textureatlassprite1.func_130010_a(), (int)textureatlassprite1.func_110967_i(), (boolean)false, (boolean)false);
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Stitching texture atlas");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Texture being stitched together");
                crashreportcategory.func_71507_a("Atlas path", (Object)this.field_94254_c);
                crashreportcategory.func_71507_a("Sprite", (Object)textureatlassprite1);
                throw new ReportedException(crashreport);
            }
            if (!textureatlassprite1.func_130098_m()) continue;
            this.field_94258_i.add(textureatlassprite1);
        }
        for (TextureAtlasSprite textureatlassprite2 : map.values()) {
            textureatlassprite2.func_94217_a(this.field_94249_f);
        }
        ProgressManager.pop((ProgressManager.ProgressBar)bar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean generateMipmaps(IResourceManager resourceManager, final TextureAtlasSprite texture) {
        block10: {
            ResourceLocation resourcelocation = this.getResourceLocation(texture);
            IResource iresource = null;
            if (!texture.hasCustomLoader(resourceManager, resourcelocation)) {
                boolean flag;
                try {
                    iresource = resourceManager.func_110536_a(resourcelocation);
                    texture.func_188539_a(iresource, 1);
                    break block10;
                }
                catch (RuntimeException runtimeexception) {
                    Log.error("Unable to parse metadata from {}", resourcelocation, runtimeexception);
                    flag = false;
                }
                catch (IOException ioexception) {
                    boolean flag2;
                    Log.error("Using missing texture, unable to load {}", resourcelocation, ioexception);
                    boolean bl = flag2 = false;
                    return bl;
                }
                finally {
                    IOUtils.closeQuietly((Closeable)iresource);
                }
                return flag;
            }
        }
        try {
            texture.func_147963_d(0);
            return true;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Applying mipmap");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Sprite being mipmapped");
            crashreportcategory.func_189529_a("Sprite name", (ICrashReportDetail)new ICrashReportDetail<String>(){

                public String call() throws Exception {
                    return texture.func_94215_i();
                }
            });
            crashreportcategory.func_189529_a("Sprite size", (ICrashReportDetail)new ICrashReportDetail<String>(){

                public String call() throws Exception {
                    return texture.func_94211_a() + " x " + texture.func_94216_b();
                }
            });
            crashreportcategory.func_189529_a("Sprite frames", (ICrashReportDetail)new ICrashReportDetail<String>(){

                public String call() throws Exception {
                    return texture.func_110970_k() + " frames";
                }
            });
            crashreportcategory.func_71507_a("Mipmap levels", (Object)0);
            throw new ReportedException(crashreport);
        }
    }

    private ResourceLocation getResourceLocation(TextureAtlasSprite p_184396_1_) {
        ResourceLocation resourcelocation = new ResourceLocation(p_184396_1_.func_94215_i());
        return new ResourceLocation(resourcelocation.func_110624_b(), String.format("%s/%s%s", this.field_94254_c, resourcelocation.func_110623_a(), ".png"));
    }
}

