package forestry.core.gui;

import forestry.core.config.Constants;
import forestry.core.gui.widgets.WidgetCamouflageSlot;
import forestry.core.inventory.ItemInventoryCamouflageSprayCan;
import forestry.core.render.ColourProperties;
import forestry.core.utils.Translator;
import net.minecraft.entity.player.EntityPlayer;

public class GuiCamouflageSprayCan extends GuiForestry<ContainerCamouflageSprayCan, ItemInventoryCamouflageSprayCan> {

	public GuiCamouflageSprayCan(EntityPlayer player, ItemInventoryCamouflageSprayCan inventory) {
		super(Constants.TEXTURE_PATH_GUI + "/camouflageSprayCan.png", new ContainerCamouflageSprayCan(inventory, player.field_71071_by), inventory);
		
		widgetManager.add(new WidgetCamouflageSlot(widgetManager, 80, 39, inventory, null));
	}
	
	@Override
	protected void func_146976_a(float f, int mouseX, int mouseY) {
		super.func_146976_a(f, mouseX, mouseY);

		String name = Translator.translateToLocal("for.gui.camouflage.spray.can");
		textLayout.line = 6;
		textLayout.drawCenteredLine(name, 0, ColourProperties.INSTANCE.get("gui.title"));
		bindTexture(textureFile);
	}

}
