/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import forestry.api.core.ICamouflageHandler;
import forestry.api.core.ICamouflagedTile;
import forestry.api.multiblock.IMultiblockComponent;
import forestry.api.multiblock.IMultiblockController;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import java.io.IOException;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class CamouflageUtil {
    public static void writeCamouflageBlockToNBT(NBTTagCompound data, ICamouflageHandler handler, String type) {
        ItemStack camouflageBlock = handler.getCamouflageBlock(type);
        if (camouflageBlock != null) {
            NBTTagCompound nbtTag = new NBTTagCompound();
            camouflageBlock.func_77955_b(nbtTag);
            data.func_74782_a("Camouflage" + type, (NBTBase)nbtTag);
        }
    }

    public static void readCamouflageBlockFromNBT(NBTTagCompound data, ICamouflageHandler handler, String type) {
        if (data.func_74764_b("Camouflage" + type)) {
            handler.setCamouflageBlock(type, ItemStack.func_77949_a((NBTTagCompound)data.func_74775_l("Camouflage" + type)), false);
        }
    }

    public static void writeCamouflageBlockToData(DataOutputStreamForestry data, ICamouflageHandler handler, String type) throws IOException {
        ItemStack camouflageBlock = handler.getCamouflageBlock(type);
        if (camouflageBlock != null) {
            data.writeShort(1);
            data.writeUTF(type);
            data.writeItemStack(camouflageBlock);
        } else {
            data.writeShort(0);
        }
    }

    public static void readCamouflageBlockFromData(DataInputStreamForestry data, ICamouflageHandler handler) throws IOException {
        if (data.readShort() == 1) {
            handler.setCamouflageBlock(data.readUTF(), data.readItemStack(), false);
        }
    }

    public static ICamouflageHandler getCamouflageHandler(IBlockAccess world, BlockPos pos) {
        if (pos == null || world == null) {
            return null;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof ICamouflagedTile) {
            IMultiblockComponent component;
            IMultiblockController controller;
            ICamouflagedTile block = (ICamouflagedTile)tile;
            String type = block.getCamouflageType();
            ICamouflageHandler handler = null;
            if (tile instanceof ICamouflageHandler) {
                handler = (ICamouflageHandler)tile;
            }
            if ((handler == null || handler.getCamouflageBlock(type) == null) && tile instanceof IMultiblockComponent && (controller = (component = (IMultiblockComponent)tile).getMultiblockLogic().getController()) instanceof ICamouflageHandler) {
                handler = (ICamouflageHandler)((Object)controller);
            }
            return handler;
        }
        return null;
    }

    public static ItemStack getCamouflageBlock(IBlockAccess world, BlockPos pos) {
        if (pos == null || world == null) {
            return null;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof ICamouflagedTile) {
            IMultiblockComponent component;
            IMultiblockController controller;
            ICamouflagedTile block = (ICamouflagedTile)tile;
            String type = block.getCamouflageType();
            ItemStack camouflageStack = null;
            ICamouflageHandler tileHandler = null;
            ICamouflageHandler multiblockHandler = null;
            if (tile instanceof ICamouflageHandler) {
                tileHandler = (ICamouflageHandler)tile;
                camouflageStack = tileHandler.getCamouflageBlock(type);
            }
            if (camouflageStack == null && tile instanceof IMultiblockComponent && (controller = (component = (IMultiblockComponent)tile).getMultiblockLogic().getController()).isAssembled() && controller instanceof ICamouflageHandler) {
                multiblockHandler = (ICamouflageHandler)((Object)controller);
                camouflageStack = multiblockHandler.getCamouflageBlock(type);
            }
            if (camouflageStack == null) {
                if (tileHandler != null) {
                    camouflageStack = tileHandler.getDefaultCamouflageBlock(type);
                }
                if (multiblockHandler != null && camouflageStack == null) {
                    camouflageStack = multiblockHandler.getDefaultCamouflageBlock(type);
                }
            }
            return camouflageStack;
        }
        return null;
    }
}

