/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.items;

import forestry.api.arboriculture.ITree;
import forestry.api.core.IModelManager;
import forestry.api.core.ISpriteRegister;
import forestry.api.core.ITextureManager;
import forestry.api.core.Tabs;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IIndividual;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.lepidopterology.EnumFlutterType;
import forestry.api.lepidopterology.IAlleleButterflyCocoon;
import forestry.api.lepidopterology.IAlleleButterflySpecies;
import forestry.api.lepidopterology.IButterfly;
import forestry.api.lepidopterology.IButterflyGenome;
import forestry.api.lepidopterology.IButterflyNursery;
import forestry.core.config.Config;
import forestry.core.genetics.ItemGE;
import forestry.core.items.IColoredItem;
import forestry.core.network.packets.PacketFXSignal;
import forestry.core.proxy.Proxies;
import forestry.core.utils.BlockUtil;
import forestry.core.utils.EntityUtil;
import forestry.core.utils.GeneticsUtil;
import forestry.core.utils.Translator;
import forestry.lepidopterology.PluginLepidopterology;
import forestry.lepidopterology.entities.EntityButterfly;
import forestry.lepidopterology.genetics.ButterflyGenome;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemButterflyGE
extends ItemGE
implements ISpriteRegister,
IColoredItem {
    private static final Random rand = new Random();
    public static final String NBT_AGE = "Age";
    private final EnumFlutterType type;

    public ItemButterflyGE(EnumFlutterType type) {
        super(Tabs.tabLepidopterology);
        this.type = type;
    }

    @Override
    public IButterfly getIndividual(ItemStack itemstack) {
        return ButterflyManager.butterflyRoot.getMember(itemstack);
    }

    @Override
    protected IAlleleSpecies getSpecies(ItemStack itemStack) {
        return ButterflyGenome.getSpecies(itemStack);
    }

    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List<ItemStack> itemList) {
        this.addCreativeItems(itemList, true);
    }

    public void addCreativeItems(List<ItemStack> itemList, boolean hideSecrets) {
        if (this.type == EnumFlutterType.COCOON) {
            for (int age = 0; age < 3; ++age) {
                for (IIndividual iIndividual : ButterflyManager.butterflyRoot.getIndividualTemplates()) {
                    if (hideSecrets && iIndividual.isSecret() && !Config.isDebug) continue;
                    ItemStack butterfly = ButterflyManager.butterflyRoot.getMemberStack(iIndividual, this.type);
                    if (this.type == EnumFlutterType.COCOON) {
                        butterfly.func_77978_p().func_74768_a(NBT_AGE, age);
                    }
                    itemList.add(butterfly);
                }
            }
        } else {
            for (IIndividual iIndividual : ButterflyManager.butterflyRoot.getIndividualTemplates()) {
                if (hideSecrets && iIndividual.isSecret() && !Config.isDebug) continue;
                itemList.add(ButterflyManager.butterflyRoot.getMemberStack(iIndividual, this.type));
            }
        }
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        if (this.type != EnumFlutterType.BUTTERFLY) {
            return false;
        }
        if (entityItem.field_70170_p.field_72995_K || entityItem.field_70173_aa < 80) {
            return false;
        }
        if (rand.nextInt(24) != 0) {
            return false;
        }
        IButterfly butterfly = ButterflyManager.butterflyRoot.getMember(entityItem.func_92059_d());
        if (butterfly == null) {
            return false;
        }
        if (!butterfly.canTakeFlight(entityItem.field_70170_p, entityItem.field_70165_t, entityItem.field_70163_u, entityItem.field_70161_v)) {
            return false;
        }
        if (entityItem.field_70170_p.func_72907_a(EntityButterfly.class) > PluginLepidopterology.entityConstraint) {
            return false;
        }
        if (EntityUtil.spawnEntity(entityItem.field_70170_p, new EntityButterfly(entityItem.field_70170_p, butterfly), entityItem.field_70165_t, entityItem.field_70163_u, entityItem.field_70161_v) != null) {
            if (entityItem.func_92059_d().field_77994_a > 1) {
                --entityItem.func_92059_d().field_77994_a;
            } else {
                entityItem.func_70106_y();
            }
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getColourFromSpecies(IAlleleSpecies species, int renderPass) {
        if (species != null) {
            return species.getSpriteColour(renderPass);
        }
        return 0xFFFFFF;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        switch (this.type) {
            case CATERPILLAR: {
                manager.registerItemModel(item, 0, "caterpillar");
                break;
            }
            case BUTTERFLY: {
                manager.registerItemModel(item, 0, "butterflyGE");
                break;
            }
            case COCOON: {
                manager.registerItemModel(item, new CocoonMeshDefinition());
                for (IAllele allele : AlleleManager.alleleRegistry.getRegisteredAlleles().values()) {
                    if (!(allele instanceof IAlleleButterflyCocoon)) continue;
                    for (int age = 0; age < 3; ++age) {
                        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{((IAlleleButterflyCocoon)allele).getCocoonItemModel(age)});
                    }
                }
                break;
            }
            default: {
                manager.registerItemModel(item, 0, "liquids/jar");
            }
        }
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return EnumActionResult.PASS;
        }
        IButterfly flutter = ButterflyManager.butterflyRoot.getMember(stack);
        if (flutter == null) {
            return EnumActionResult.PASS;
        }
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        IBlockState blockState = worldIn.func_180495_p(pos);
        if (this.type == EnumFlutterType.COCOON) {
            int yShift;
            int age = stack.func_77978_p().func_74762_e(NBT_AGE);
            if (!BlockUtil.isReplaceableBlock(blockState, worldIn, pos)) {
                if (!worldIn.func_175623_d(pos.func_177977_b())) {
                    return EnumActionResult.PASS;
                }
                yShift = 1;
            } else {
                yShift = 0;
            }
            BlockPos posS = pos.func_177982_a(0, -yShift, 0);
            IButterflyNursery nursery = null;
            if (tileEntity instanceof IButterflyNursery) {
                nursery = (IButterflyNursery)tileEntity;
            } else {
                IIndividual treeLeave = GeneticsUtil.getPollen(worldIn, pos);
                if (treeLeave != null && treeLeave instanceof ITree && ((ITree)treeLeave).setLeaves(worldIn, playerIn.func_146103_bH(), pos)) {
                    nursery = (IButterflyNursery)worldIn.func_175625_s(pos);
                }
            }
            if (nursery != null && nursery.canNurse(flutter)) {
                nursery.setCaterpillar(flutter);
                if (ButterflyManager.butterflyRoot.plantCocoon(worldIn, nursery, playerIn.func_146103_bH(), age)) {
                    PacketFXSignal packet = new PacketFXSignal(PacketFXSignal.SoundFXType.BLOCK_PLACE, pos, worldIn.func_180495_p(posS));
                    Proxies.net.sendNetworkPacket(packet, worldIn);
                    if (!playerIn.field_71075_bZ.field_75098_d) {
                        --stack.field_77994_a;
                    }
                    nursery.setCaterpillar(null);
                    return EnumActionResult.SUCCESS;
                }
                nursery.setCaterpillar(null);
                return EnumActionResult.PASS;
            }
            return EnumActionResult.PASS;
        }
        if (this.type == EnumFlutterType.CATERPILLAR) {
            if (!(tileEntity instanceof IButterflyNursery)) {
                return EnumActionResult.PASS;
            }
            IButterflyNursery pollinatable = (IButterflyNursery)tileEntity;
            if (!pollinatable.canNurse(flutter)) {
                return EnumActionResult.PASS;
            }
            pollinatable.setCaterpillar(flutter);
            PacketFXSignal packet = new PacketFXSignal(PacketFXSignal.VisualFXType.BLOCK_BREAK, PacketFXSignal.SoundFXType.BLOCK_BREAK, pos, blockState);
            Proxies.net.sendNetworkPacket(packet, worldIn);
            if (!playerIn.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerSprites(ITextureManager manager) {
        for (IAllele allele : AlleleManager.alleleRegistry.getRegisteredAlleles().values()) {
            if (!(allele instanceof IAlleleButterflySpecies)) continue;
            ((IAlleleButterflySpecies)allele).registerSprites();
        }
    }

    public String func_77653_i(ItemStack itemstack) {
        if (itemstack.func_77978_p() == null) {
            return super.func_77653_i(itemstack);
        }
        IButterfly individual = ButterflyManager.butterflyRoot.getMember(itemstack);
        String customKey = "for.butterflies.custom." + this.type.getName() + "." + individual.getGenome().getPrimary().getUnlocalizedName().replace("butterflies.species.", "");
        if (Translator.canTranslateToLocal(customKey)) {
            return Translator.translateToLocal(customKey);
        }
        String grammar = Translator.translateToLocal("for.butterflies.grammar." + this.type.getName());
        String speciesString = individual.getDisplayName();
        String typeString = Translator.translateToLocal("for.butterflies.grammar." + this.type.getName() + ".type");
        return grammar.replaceAll("%SPECIES", speciesString).replaceAll("%TYPE", typeString);
    }

    @Override
    public int getColorFromItemstack(ItemStack stack, int tintIndex) {
        IAlleleSpecies species;
        if (stack.func_77942_o() && (species = AlleleManager.alleleRegistry.getIndividual(stack).getGenome().getPrimary()) != null) {
            return species.getSpriteColour(tintIndex);
        }
        return 0xFFFFFF;
    }

    private static class CocoonMeshDefinition
    implements ItemMeshDefinition {
        private CocoonMeshDefinition() {
        }

        public ModelResourceLocation func_178113_a(ItemStack itemstack) {
            int age = itemstack.func_77978_p().func_74762_e(ItemButterflyGE.NBT_AGE);
            IButterflyGenome genome = (IButterflyGenome)AlleleManager.alleleRegistry.getIndividual(itemstack).getGenome();
            return genome.getCocoon().getCocoonItemModel(age);
        }
    }
}

