/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.core.inventory;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

import forestry.api.core.INbtReadable;
import forestry.api.core.INbtWritable;
import forestry.core.utils.InventoryUtil;

public class InventoryPlain implements IInventory, INbtWritable, INbtReadable {

	private final ItemStack[] contents;
	private final String name;
	private final int stackLimit;

	public InventoryPlain(int size) {
		this(size, null, 64);
	}

	
	public InventoryPlain(int size, String name) {
		this(size, name, 64);
	}

	public InventoryPlain(int size, String name, int stackLimit) {
		this.contents = new ItemStack[size];
		this.name = name;
		this.stackLimit = stackLimit;
	}

	public InventoryPlain(IInventory tocopy) {
		this(tocopy.func_70302_i_(), tocopy.func_70005_c_(), tocopy.func_70297_j_());
		for (int i = 0; i < tocopy.func_70302_i_(); i++) {
			if (tocopy.func_70301_a(i) != null) {
				this.func_70299_a(i, tocopy.func_70301_a(i).func_77946_l());
			} else {
				this.func_70299_a(i, null);
			}
		}
	}

	public ItemStack[] getContents() {
		return contents;
	}

	@Override
	public int func_70302_i_() {
		return contents.length;
	}

	@Override
	public ItemStack func_70301_a(int slotId) {
		return contents[slotId];
	}

	@Override
	public ItemStack func_70298_a(int slotId, int count) {
		if (contents[slotId] == null) {
			return null;
		}
		if (contents[slotId].field_77994_a > count) {
			return contents[slotId].func_77979_a(count);
		}
		ItemStack stack = contents[slotId];
		contents[slotId] = null;
		return stack;
	}

	@Override
	public void func_70299_a(int slotId, ItemStack itemstack) {
		contents[slotId] = itemstack;
	}

	@Override
	public String func_70005_c_() {
		if(name == null){
			return "Plain";
		}
		return name;
	}

	@Override
	public int func_70297_j_() {
		return stackLimit;
	}

	@Override
	public void func_70296_d() {
	}

	@Override
	public boolean func_70300_a(EntityPlayer entityplayer) {
		return false;
	}
	
	@Override
	public ItemStack func_70304_b(int slotIndex) {
		return this.func_70301_a(slotIndex);
	}
	
	@Override
	public boolean func_145818_k_() {
		return name != null;
	}
	
	@Override
	public ITextComponent func_145748_c_() {
		return new TextComponentString(func_70005_c_());
	}

	@Override
	public boolean func_94041_b(int i, ItemStack itemstack) {
		return true;
	}

	@Override
	public void func_174889_b(EntityPlayer player) {
	}

	@Override
	public void func_174886_c(EntityPlayer player) {
	}

	/* INBTagable */
	@Override
	public void readFromNBT(NBTTagCompound nbttagcompound) {
		InventoryUtil.readFromNBT(this, nbttagcompound);
	}

	@Override
	public NBTTagCompound writeToNBT(NBTTagCompound nbttagcompound) {
		InventoryUtil.writeToNBT(this, nbttagcompound);
		return nbttagcompound;
	}

	/* Fields */
	
	@Override
	public int func_174887_a_(int id) {
		return 0;
	}

	@Override
	public void func_174885_b(int id, int value) {
	}

	@Override
	public int func_174890_g() {
		return 0;
	}

	@Override
	public void func_174888_l() {
	}
}
