/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.farming.logic;

import javax.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableCollection;
import forestry.core.config.Constants;
import forestry.core.network.packets.PacketFXSignal;
import forestry.core.proxy.Proxies;
import forestry.core.utils.ItemStackUtil;
import forestry.plugins.compat.PluginIC2;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CropRubber extends CropDestroy {

	public CropRubber(World world, IBlockState blockState, BlockPos position) {
		super(world, blockState, position, getReplantState(blockState));
	}

	/**
	 * Convert a "wet" rubber log blockstate into the dry version.
	 * Total hack since we don't have access to the blockstates.
	 */
	private static <T extends Comparable<T>> IBlockState getReplantState(IBlockState sappyState) {
		if (hasRubberToHarvest(sappyState)) {
			for (Map.Entry<IProperty<?>, Comparable<?>> wetPropertyEntry : sappyState.func_177228_b().entrySet()) {
				String valueWetString = wetPropertyEntry.getValue().toString();
				String valueDryString = valueWetString.replace("wet", "dry");
				IProperty<?> property = wetPropertyEntry.getKey();

				IBlockState baseState = sappyState.func_177230_c().func_176194_O().func_177621_b();
				IBlockState dryState = getStateWithValue(baseState, property, valueDryString);
				if (dryState != null) {
					return dryState;
				}
			}
		}

		return sappyState.func_177230_c().func_176223_P();
	}

	public static boolean hasRubberToHarvest(IBlockState blockState) {
		Block block = blockState.func_177230_c();
		if (ItemStackUtil.equals(block, PluginIC2.rubberWood)) {
			ImmutableCollection<Comparable<?>> propertyValues = blockState.func_177228_b().values();
			for (Comparable<?> propertyValue : propertyValues) {
				if (propertyValue.toString().contains("wet")) {
					return true;
				}
			}
		}
		return false;
	}

	@Nullable
	private static <T extends Comparable<T>> IBlockState getStateWithValue(IBlockState baseState, IProperty<T> property, String valueString) {
		Optional<T> value = property.func_185929_b(valueString);
		if (value.isPresent()) {
			return baseState.func_177226_a(property, value.get());
		}
		return null;
	}

	@Override
	protected Collection<ItemStack> harvestBlock(World world, BlockPos pos) {
		Collection<ItemStack> harvested = new ArrayList<>();
		harvested.add(PluginIC2.resin.func_77946_l());

		PacketFXSignal packet = new PacketFXSignal(PacketFXSignal.VisualFXType.BLOCK_BREAK, PacketFXSignal.SoundFXType.BLOCK_BREAK, pos, blockState);
		Proxies.net.sendNetworkPacket(packet, world);

		world.func_180501_a(pos, replantState, Constants.FLAG_BLOCK_SYNC);
		return harvested;
	}

}
