/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.inventory;

import com.google.common.collect.ImmutableSet;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBee;
import forestry.api.core.IErrorSource;
import forestry.api.core.IErrorState;
import forestry.apiculture.PluginApiculture;
import forestry.apiculture.items.HabitatLocatorLogic;
import forestry.apiculture.items.ItemHabitatLocator;
import forestry.core.config.Config;
import forestry.core.errors.EnumErrorCode;
import forestry.core.gui.IHintSource;
import forestry.core.inventory.ItemInventory;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.biome.Biome;

public class ItemInventoryHabitatLocator
extends ItemInventory
implements IErrorSource,
IHintSource {
    private static final short SLOT_ENERGY = 2;
    private static final short SLOT_SPECIMEN = 0;
    private static final short SLOT_ANALYZED = 1;
    private final HabitatLocatorLogic locatorLogic;

    public ItemInventoryHabitatLocator(EntityPlayer player, ItemStack itemstack) {
        super(player, 3, itemstack);
        ItemHabitatLocator habitatLocator = (ItemHabitatLocator)itemstack.func_77973_b();
        this.locatorLogic = habitatLocator.getLocatorLogic();
    }

    private static boolean isEnergy(ItemStack itemstack) {
        if (itemstack == null || itemstack.field_77994_a <= 0) {
            return false;
        }
        Item item = itemstack.func_77973_b();
        return PluginApiculture.items.honeyDrop == item || PluginApiculture.items.honeydew == item;
    }

    @Override
    public void onSlotClick(int slotIndex, EntityPlayer player) {
        IBee bee;
        if (this.func_70301_a(1) != null) {
            if (this.locatorLogic.isBiomeFound()) {
                return;
            }
        } else if (this.func_70301_a(0) != null) {
            if (!ItemInventoryHabitatLocator.isEnergy(this.func_70301_a(2))) {
                return;
            }
            this.func_70298_a(2, 1);
            this.func_70299_a(1, this.func_70301_a(0));
            this.func_70299_a(0, null);
        }
        if ((bee = BeeManager.beeRoot.getMember(this.func_70301_a(1))) == null) {
            return;
        }
        this.locatorLogic.startBiomeSearch(bee, player);
    }

    public Set<Biome> getBiomesToSearch() {
        return this.locatorLogic.getTargetBiomes();
    }

    @Override
    public List<String> getHints() {
        return Config.hints.get((Object)"habitat.locator");
    }

    @Override
    public ImmutableSet<IErrorState> getErrorStates() {
        if (this.func_70301_a(1) != null) {
            return ImmutableSet.of();
        }
        ImmutableSet.Builder errorStates = ImmutableSet.builder();
        ItemStack specimen = this.func_70301_a(0);
        if (!BeeManager.beeRoot.isMember(specimen)) {
            errorStates.add((Object)EnumErrorCode.NO_SPECIMEN);
        }
        if (!ItemInventoryHabitatLocator.isEnergy(this.func_70301_a(2))) {
            errorStates.add((Object)EnumErrorCode.NO_HONEY);
        }
        return errorStates.build();
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
        if (slotIndex == 2) {
            return ItemInventoryHabitatLocator.isEnergy(itemStack);
        }
        if (slotIndex == 0) {
            return BeeManager.beeRoot.isMember(itemStack);
        }
        return false;
    }
}

