/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.gui.widgets;

import forestry.api.mail.IPostalCarrier;
import forestry.api.mail.PostManager;
import forestry.core.gui.tooltips.ToolTip;
import forestry.core.gui.widgets.Widget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.proxy.Proxies;
import forestry.core.render.TextureManager;
import forestry.core.utils.Translator;
import forestry.mail.gui.ContainerLetter;
import net.minecraft.client.renderer.GlStateManager;

public class AddresseeSlot
extends Widget {
    private final ContainerLetter containerLetter;

    public AddresseeSlot(WidgetManager widgetManager, int xPos, int yPos, ContainerLetter containerLetter) {
        super(widgetManager, xPos, yPos);
        this.containerLetter = containerLetter;
        this.width = 26;
        this.height = 15;
    }

    @Override
    public void draw(int startX, int startY) {
        IPostalCarrier carrier = PostManager.postRegistry.getCarrier(this.containerLetter.getCarrierType());
        if (carrier != null) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Proxies.render.bindTexture(TextureManager.getInstance().getGuiTextureMap());
            this.manager.gui.func_175175_a(startX + this.xPos, startY + this.yPos, carrier.getSprite(), 26, 26);
        }
    }

    @Override
    public ToolTip getToolTip(int mouseX, int mouseY) {
        String tooltipString = Translator.translateToLocal("for.gui.addressee." + (Object)((Object)this.containerLetter.getCarrierType()));
        ToolTip tooltip = new ToolTip();
        tooltip.add(tooltipString);
        return tooltip;
    }

    @Override
    public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        if (!this.containerLetter.getLetter().isProcessed()) {
            this.containerLetter.advanceCarrierType();
            Proxies.common.playButtonClick();
        }
    }
}

