/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.slots;

import forestry.core.gui.tooltips.IToolTipProvider;
import forestry.core.gui.tooltips.ToolTip;
import forestry.core.render.TextureManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class SlotForestry
extends Slot
implements IToolTipProvider {
    private boolean isPhantom;
    private boolean canAdjustPhantom = true;
    private boolean canShift = true;
    private int stackLimit;
    private ToolTip toolTips;

    public SlotForestry(IInventory inventory, int slotIndex, int xPos, int yPos) {
        super(inventory, slotIndex, xPos, yPos);
        if (inventory == null) {
            throw new IllegalArgumentException("Inventory must not be null");
        }
        this.setBackgroundLocation(TextureManager.getInstance().getGuiTextureMap());
        this.stackLimit = -1;
    }

    public SlotForestry setPhantom() {
        this.isPhantom = true;
        return this;
    }

    public SlotForestry blockShift() {
        this.canShift = false;
        return this;
    }

    public void func_75215_d(ItemStack itemStack) {
        if (!this.isPhantom() || this.canAdjustPhantom()) {
            super.func_75215_d(itemStack);
        }
    }

    public SlotForestry setCanAdjustPhantom(boolean canAdjust) {
        this.canAdjustPhantom = canAdjust;
        return this;
    }

    public SlotForestry setStackLimit(int limit) {
        this.stackLimit = limit;
        return this;
    }

    public boolean isPhantom() {
        return this.isPhantom;
    }

    public boolean canAdjustPhantom() {
        return this.canAdjustPhantom;
    }

    public boolean func_82869_a(EntityPlayer stack) {
        return !this.isPhantom();
    }

    public boolean canShift() {
        return this.canShift;
    }

    public int func_75219_a() {
        if (this.stackLimit < 0) {
            return super.func_75219_a();
        }
        return this.stackLimit;
    }

    public void setToolTips(ToolTip toolTips) {
        this.toolTips = toolTips;
    }

    @Override
    public ToolTip getToolTip(int mouseX, int mouseY) {
        return this.toolTips;
    }

    @Override
    public boolean isToolTipVisible() {
        return this.func_75211_c() == null;
    }

    @Override
    public boolean isMouseOver(int mouseX, int mouseY) {
        return mouseX >= this.field_75223_e && mouseX <= this.field_75223_e + 16 && mouseY >= this.field_75221_f && mouseY <= this.field_75221_f + 16;
    }
}

