/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.render;

import forestry.api.core.ForestryAPI;
import forestry.api.core.ISpriteRegister;
import forestry.api.core.ITextureManager;
import forestry.core.proxy.Proxies;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TextureManager
implements ITextureManager {
    private static final TextureManager INSTANCE = new TextureManager();
    private static final Map<String, TextureAtlasSprite> defaultIcons = new HashMap<String, TextureAtlasSprite>();
    private final List<ISpriteRegister> spriteRegisters = new ArrayList<ISpriteRegister>();

    public static TextureManager getInstance() {
        return INSTANCE;
    }

    private TextureManager() {
    }

    public static void initDefaultSprites() {
        String[] defaultIconNames;
        for (String identifier : defaultIconNames = new String[]{"habitats/desert", "habitats/end", "habitats/forest", "habitats/hills", "habitats/jungle", "habitats/mushroom", "habitats/nether", "habitats/ocean", "habitats/plains", "habitats/snow", "habitats/swamp", "habitats/taiga", "misc/access.shared", "misc/energy", "misc/hint", "analyzer/anything", "analyzer/bee", "analyzer/cave", "analyzer/closed", "analyzer/drone", "analyzer/flyer", "analyzer/item", "analyzer/nocturnal", "analyzer/princess", "analyzer/pure_breed", "analyzer/pure_cave", "analyzer/pure_flyer", "analyzer/pure_nocturnal", "analyzer/queen", "errors/errored", "errors/unknown", "slots/blocked", "slots/blocked_2", "slots/liquid", "slots/container", "slots/locked", "mail/carrier.player", "mail/carrier.trader"}) {
            ResourceLocation resourceLocation = new ResourceLocation("forestry", "gui/" + identifier);
            TextureAtlasSprite icon = TextureManager.registerSprite(resourceLocation);
            defaultIcons.put(identifier, icon);
        }
    }

    public static TextureAtlasSprite registerSprite(ResourceLocation location) {
        TextureMap textureMap = Proxies.common.getClientInstance().func_147117_R();
        return textureMap.func_174942_a(location);
    }

    @Override
    public TextureAtlasSprite getDefault(String ident) {
        return defaultIcons.get(ident);
    }

    public void registerBlock(Block block) {
        if (block instanceof ISpriteRegister) {
            this.spriteRegisters.add((ISpriteRegister)block);
        }
    }

    public void registerItem(Item item) {
        if (item instanceof ISpriteRegister) {
            this.spriteRegisters.add((ISpriteRegister)item);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerSprites() {
        for (ISpriteRegister spriteRegister : this.spriteRegisters) {
            spriteRegister.registerSprites(TextureManager.getInstance());
        }
    }

    static {
        ForestryAPI.textureManager = INSTANCE;
    }
}

