/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes.jei.moistener;

import forestry.api.fuels.MoistenerFuel;
import forestry.api.recipes.IMoistenerRecipe;
import forestry.core.recipes.jei.ForestryRecipeWrapper;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class MoistenerRecipeWrapper
extends ForestryRecipeWrapper<IMoistenerRecipe> {
    @Nonnull
    private final MoistenerFuel fuel;

    public MoistenerRecipeWrapper(@Nonnull IMoistenerRecipe recipe, @Nonnull MoistenerFuel fuel) {
        super(recipe);
        this.fuel = fuel;
    }

    public void getIngredients(@Nonnull IIngredients ingredients) {
        IMoistenerRecipe recipe = (IMoistenerRecipe)this.getRecipe();
        ArrayList<ItemStack> itemStackInputs = new ArrayList<ItemStack>();
        itemStackInputs.add(recipe.getResource());
        ItemStack fuelItem = this.fuel.getItem();
        if (fuelItem != null) {
            itemStackInputs.add(fuelItem);
        }
        ingredients.setInputs(ItemStack.class, itemStackInputs);
        ArrayList<ItemStack> itemStackOutputs = new ArrayList<ItemStack>();
        itemStackOutputs.add(recipe.getProduct());
        ItemStack fuelProduct = this.fuel.getProduct();
        if (fuelProduct != null) {
            itemStackOutputs.add(fuelProduct);
        }
        ingredients.setOutputs(ItemStack.class, itemStackOutputs);
        ingredients.setInput(FluidStack.class, (Object)new FluidStack(FluidRegistry.WATER, recipe.getTimePerItem() / 4));
    }

    @Nonnull
    public MoistenerFuel getFuel() {
        return this.fuel;
    }
}

