/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.render;

import com.google.common.base.Function;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.lepidopterology.IButterfly;
import forestry.core.models.BlankModel;
import forestry.core.models.DefaultTextureGetter;
import forestry.core.models.TRSRBakedModel;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.ModelProcessingHelper;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelButterflyItem
extends BlankModel {
    private final Function<ResourceLocation, TextureAtlasSprite> textureGetter = new DefaultTextureGetter();
    @SideOnly(value=Side.CLIENT)
    private static IModel modelButterfly;
    private static final Cache<IButterfly, IBakedModel> cache;

    public static void onModelBake(ModelBakeEvent event) {
        modelButterfly = null;
        cache.invalidateAll();
    }

    @Override
    protected ItemOverrideList createOverrides() {
        return new ButterflyItemOverrideList();
    }

    private IBakedModel bakeModel(IButterfly butterfly) {
        ImmutableMap.Builder textures = ImmutableMap.builder();
        textures.put((Object)"butterfly", (Object)butterfly.getGenome().getPrimary().getItemTexture());
        if (modelButterfly == null) {
            try {
                modelButterfly = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("forestry:item/butterflyGE"));
            }
            catch (Exception e) {
                return null;
            }
            if (modelButterfly == null) {
                return null;
            }
        }
        IModel retexturedModel = ModelProcessingHelper.retexture((IModel)modelButterfly, (ImmutableMap)textures.build());
        return new TRSRBakedModel(retexturedModel.bake((IModelState)ModelRotation.X0_Y0, DefaultVertexFormats.field_176599_b, this.textureGetter), -0.03125f, 0.5f, -0.03125f, butterfly.getSize() * 1.5f);
    }

    static {
        cache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
    }

    private class ButterflyItemOverrideList
    extends ItemOverrideList {
        public ButterflyItemOverrideList() {
            super(Collections.emptyList());
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            IButterfly butterfly = ButterflyManager.butterflyRoot.getMember(stack);
            if (butterfly == null) {
                butterfly = ButterflyManager.butterflyRoot.templateAsIndividual(ButterflyManager.butterflyRoot.getDefaultTemplate());
            }
            if (cache.getIfPresent((Object)butterfly) == null) {
                cache.put((Object)butterfly, (Object)ModelButterflyItem.this.bakeModel(butterfly));
            }
            return (IBakedModel)cache.getIfPresent((Object)butterfly);
        }
    }
}

