/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.FarmDirection;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmable;
import forestry.core.utils.BlockUtil;
import forestry.farming.FarmHelper;
import forestry.farming.logic.FarmLogic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class FarmLogicHomogeneous
extends FarmLogic {
    private final ItemStack resource;
    private final IBlockState soilState;
    protected final List<IFarmable> farmables;
    List<ItemStack> produce = new ArrayList<ItemStack>();

    protected FarmLogicHomogeneous(ItemStack resource, @Nonnull IBlockState soilState, Collection<IFarmable> farmables) {
        this.resource = resource;
        this.soilState = soilState;
        this.farmables = new ArrayList<IFarmable>(farmables);
    }

    protected boolean isAcceptedSoil(@Nonnull IBlockState blockState) {
        return this.soilState.func_177230_c() == blockState.func_177230_c();
    }

    @Override
    public boolean isAcceptedResource(ItemStack itemstack) {
        return this.resource.func_77969_a(itemstack);
    }

    @Override
    public boolean isAcceptedGermling(ItemStack itemstack) {
        for (IFarmable germling : this.farmables) {
            if (!germling.isGermling(itemstack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAcceptedWindfall(ItemStack itemstack) {
        for (IFarmable germling : this.farmables) {
            if (!germling.isWindfall(itemstack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean cultivate(World world, IFarmHousing farmHousing, BlockPos pos, FarmDirection direction, int extent) {
        if (this.maintainSoil(world, farmHousing, pos, direction, extent)) {
            return true;
        }
        return this.maintainGermlings(world, farmHousing, pos.func_177984_a(), direction, extent);
    }

    private boolean maintainSoil(World world, IFarmHousing farmHousing, BlockPos pos, FarmDirection direction, int extent) {
        BlockPos position;
        IBlockState soilState;
        ItemStack[] resources = new ItemStack[]{this.resource};
        if (!farmHousing.getFarmInventory().hasResources(resources)) {
            return false;
        }
        for (int i = 0; i < extent && !FarmHelper.bricks.contains((Object)(soilState = world.func_180495_p(position = this.translateWithOffset(pos, direction, i))).func_177230_c()); ++i) {
            if (this.isAcceptedSoil(soilState)) continue;
            BlockPos platformPosition = position.func_177977_b();
            IBlockState platformState = world.func_180495_p(platformPosition);
            if (!FarmHelper.bricks.contains((Object)platformState.func_177230_c())) break;
            this.produce.addAll(BlockUtil.getBlockDrops(world, position));
            BlockUtil.setBlockWithPlaceSound(world, position, this.soilState);
            farmHousing.getFarmInventory().removeResources(resources);
            return true;
        }
        return false;
    }

    protected abstract boolean maintainGermlings(World var1, IFarmHousing var2, BlockPos var3, FarmDirection var4, int var5);
}

