/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.climate;

import forestry.api.climate.IClimateManager;
import forestry.api.climate.IClimatePosition;
import forestry.api.climate.IClimateProvider;
import forestry.api.climate.IClimateRegion;
import forestry.api.climate.IClimateSourceProvider;
import forestry.api.core.ForestryAPI;
import forestry.core.DefaultClimateProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ClimateManager
implements IClimateManager {
    protected Map<Integer, List<IClimateRegion>> regions = new HashMap<Integer, List<IClimateRegion>>();
    private final Object regionsMutex = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRegion(IClimateRegion region) {
        if (region == null) {
            return;
        }
        Object object = this.regionsMutex;
        synchronized (object) {
            List<IClimateRegion> regions;
            Integer dimensionID = region.getWorld().field_73011_w.getDimension();
            if (!this.regions.containsKey(dimensionID)) {
                this.regions.put(dimensionID, new ArrayList());
            }
            if (!(regions = this.regions.get(dimensionID)).contains(region)) {
                for (BlockPos pos : region.getPositions().keySet()) {
                    if (this.getRegionForPos(region.getWorld(), pos) == null) continue;
                    return;
                }
                regions.add(region);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRegion(IClimateRegion region) {
        if (region == null) {
            return;
        }
        Object object = this.regionsMutex;
        synchronized (object) {
            List<IClimateRegion> regions;
            Integer dimensionID = region.getWorld().field_73011_w.getDimension();
            if (!this.regions.containsKey(dimensionID)) {
                this.regions.put(dimensionID, new ArrayList());
            }
            if ((regions = this.regions.get(dimensionID)).contains(region)) {
                regions.remove(region);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSource(IClimateSourceProvider source) {
        if (source == null) {
            return;
        }
        Object object = this.regionsMutex;
        synchronized (object) {
            IClimateRegion region;
            Integer dimensionID = source.getWorldObj().field_73011_w.getDimension();
            if (!this.regions.containsKey(dimensionID)) {
                this.regions.put(dimensionID, new ArrayList());
            }
            if ((region = this.getRegionForPos(source.getWorldObj(), source.getCoordinates())) != null && !region.getSources().contains(source.getClimateSource())) {
                region.removeSource(source.getClimateSource());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSource(IClimateSourceProvider source) {
        if (source == null) {
            return;
        }
        Object object = this.regionsMutex;
        synchronized (object) {
            IClimateRegion region;
            Integer dimensionID = source.getWorldObj().field_73011_w.getDimension();
            if (!this.regions.containsKey(dimensionID)) {
                this.regions.put(dimensionID, new ArrayList());
            }
            if ((region = this.getRegionForPos(source.getWorldObj(), source.getCoordinates())) != null && !region.getSources().contains(source.getClimateSource())) {
                region.addSource(source.getClimateSource());
            }
        }
    }

    @Override
    public float getTemperature(World world, BlockPos pos) {
        IClimatePosition position = ForestryAPI.climateManager.getPosition(world, pos);
        if (position != null) {
            return position.getTemperature();
        }
        return world.func_180494_b(pos).func_185353_n();
    }

    @Override
    public float getHumidity(World world, BlockPos pos) {
        IClimatePosition position = ForestryAPI.climateManager.getPosition(world, pos);
        if (position != null) {
            return position.getHumidity();
        }
        return world.func_180494_b(pos).func_76727_i();
    }

    @Override
    public Map<Integer, List<IClimateRegion>> getRegions() {
        return this.regions;
    }

    @Override
    public IClimatePosition getPosition(World world, BlockPos pos) {
        Integer dimensionID = world.field_73011_w.getDimension();
        if (!this.regions.containsKey(dimensionID)) {
            this.regions.put(dimensionID, new ArrayList());
            return null;
        }
        for (IClimateRegion region : this.regions.get(dimensionID)) {
            if (!region.getPositions().keySet().contains(pos)) continue;
            return region.getPositions().get(pos);
        }
        return null;
    }

    @Override
    public IClimateRegion getRegionForPos(World world, BlockPos pos) {
        Integer dimensionID = world.field_73011_w.getDimension();
        if (!this.regions.containsKey(dimensionID)) {
            this.regions.put(dimensionID, new ArrayList());
        }
        List<IClimateRegion> regions = this.regions.get(dimensionID);
        for (IClimateRegion region : regions) {
            if (region.getPositions().keySet().contains(pos)) {
                return region;
            }
            if (!region.getOtherPositions().contains(pos)) continue;
            return region;
        }
        return null;
    }

    @Override
    public IClimateProvider getDefaultClimate(World world, BlockPos pos) {
        return new DefaultClimateProvider(world, pos);
    }
}

