/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes;

import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class BottlerRecipe {
    public final FluidStack fluid;
    public final ItemStack inputStack;
    @Nullable
    public final ItemStack outputStack;
    public final boolean fillRecipe;

    public static BottlerRecipe createFilled(ItemStack filled) {
        if (filled == null) {
            return null;
        }
        ItemStack empty = filled.func_77946_l();
        empty.field_77994_a = 1;
        IFluidHandler fluidHandler = FluidUtil.getFluidHandler((ItemStack)empty);
        if (fluidHandler == null) {
            return null;
        }
        FluidStack fill = fluidHandler.drain(Integer.MAX_VALUE, true);
        if (fill != null && fill.amount > 0) {
            return new BottlerRecipe(empty, fill, filled, false);
        }
        return null;
    }

    public static BottlerRecipe createEmpty(Fluid res, ItemStack empty) {
        if (res == null || empty == null) {
            return null;
        }
        ItemStack filled = empty.func_77946_l();
        filled.field_77994_a = 1;
        IFluidHandler fluidHandler = FluidUtil.getFluidHandler((ItemStack)filled);
        if (fluidHandler == null) {
            return null;
        }
        int fillAmount = fluidHandler.fill(new FluidStack(res, Integer.MAX_VALUE), true);
        if (fillAmount > 0) {
            return new BottlerRecipe(empty, new FluidStack(res, fillAmount), filled, true);
        }
        return null;
    }

    public BottlerRecipe(ItemStack inputStack, FluidStack fluid, @Nullable ItemStack outputStack, boolean fillRecipe) {
        this.fluid = fluid;
        this.inputStack = inputStack;
        this.outputStack = outputStack;
        this.fillRecipe = fillRecipe;
    }

    public boolean matchEmpty(ItemStack emptyCan, FluidStack resource) {
        return emptyCan != null && resource != null && emptyCan.func_77969_a(this.inputStack) && resource.containsFluid(this.fluid) && this.fillRecipe;
    }

    public boolean matchFilled(ItemStack filledCan) {
        return this.outputStack != null && !this.fillRecipe && this.outputStack.func_77969_a(filledCan);
    }
}

