/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.greenhouse.tiles;

import net.minecraft.item.ItemStack;
import forestry.core.utils.ItemStackUtil;

public class TileGreenhouseDoor extends TileGreenhouse {

	public TileGreenhouseDoor() {
	}
	
	@Override
	public boolean setCamouflageBlock(String type, ItemStack camouflageBlock, boolean sendClientUpdate) {
		if(!ItemStackUtil.isIdenticalItem(camouflageBlock, this.camouflageBlock)){
			super.setCamouflageBlock(type, camouflageBlock, sendClientUpdate);
			TileGreenhouseDoor otherDoorTile = null;
			if(field_145850_b.func_175625_s(field_174879_c.func_177984_a()) instanceof TileGreenhouseDoor){
				otherDoorTile = (TileGreenhouseDoor) field_145850_b.func_175625_s(field_174879_c.func_177984_a());
			}else if(field_145850_b.func_175625_s(field_174879_c.func_177977_b()) instanceof TileGreenhouseDoor){
				otherDoorTile = (TileGreenhouseDoor) field_145850_b.func_175625_s(field_174879_c.func_177977_b());
			}
			if(otherDoorTile != null){
				return otherDoorTile.setCamouflageBlock(type, camouflageBlock, sendClientUpdate);
			}
		}
		return false;
	}

}
