package forestry.apiculture.items;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import forestry.api.apiculture.ApicultureCapabilities;
import forestry.api.apiculture.IHiveTile;
import forestry.api.core.Tabs;
import forestry.core.items.ItemForestry;
import forestry.core.proxy.Proxies;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ItemSmoker extends ItemForestry {
	public ItemSmoker() {
		super(Tabs.tabApiculture);
		func_77625_d(1);
	}

	@Override
	public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
		super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
		if (worldIn.field_72995_K && isSelected && worldIn.field_73012_v.nextInt(40) == 0) {
			addSmoke(stack, worldIn, entityIn, 1);
		}
	}

	@Override
	public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
		super.onUsingTick(stack, player, count);
		World worldObj = player.field_70170_p;
		addSmoke(stack, worldObj, player, (count % 5) + 1);
	}

	private static EnumHandSide getHandSide(ItemStack stack, Entity entity) {
		if (entity instanceof EntityLivingBase) {
			EntityLivingBase entityLivingBase = (EntityLivingBase) entity;
			EnumHand activeHand = entityLivingBase.func_184600_cs();
			EnumHandSide handSide = entityLivingBase.func_184591_cq();
			if (activeHand == EnumHand.OFF_HAND) {
				// TODO: use EnumHandSide.opposite() when it's no longer client-only
				handSide = handSide == EnumHandSide.LEFT ? EnumHandSide.RIGHT : EnumHandSide.LEFT;
			}
			return handSide;
		}
		return EnumHandSide.RIGHT;
	}

	private static void addSmoke(ItemStack stack, World worldObj, Entity entity, int distance) {
		if (distance <= 0) {
			return;
		}
		Vec3d look = entity.func_70040_Z();
		EnumHandSide handSide = getHandSide(stack, entity);

		Vec3d handOffset;
		if (handSide == EnumHandSide.RIGHT) {
			handOffset = look.func_72431_c(new Vec3d(0, 1, 0));
		} else {
			handOffset = look.func_72431_c(new Vec3d(0, -1, 0));
		}

		Vec3d lookDistance = new Vec3d(look.field_72450_a * distance, look.field_72448_b * distance, look.field_72449_c * distance);
		Vec3d scaledOffset = handOffset.func_186678_a(1.0 / distance);
		Vec3d smokePos = lookDistance.func_178787_e(entity.func_174791_d()).func_178787_e(scaledOffset);

		Proxies.render.addEntitySmokeFX(worldObj, smokePos.field_72450_a, smokePos.field_72448_b + 1, smokePos.field_72449_c);
		BlockPos blockPos = new BlockPos(smokePos.field_72450_a, smokePos.field_72448_b + 1, smokePos.field_72449_c);
		TileEntity tileEntity = worldObj.func_175625_s(blockPos);
		if (tileEntity instanceof IHiveTile) {
			IHiveTile hive = (IHiveTile) tileEntity;
			hive.calmBees();
		}
	}

	@Override
	public ActionResult<ItemStack> func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
		playerIn.func_184598_c(hand);
		return new ActionResult<>(EnumActionResult.SUCCESS, itemStackIn);
	}

	@Override
	public EnumActionResult onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
		TileEntity tileEntity = world.func_175625_s(pos);
		if (tileEntity instanceof IHiveTile) {
			IHiveTile hive = (IHiveTile) tileEntity;
			hive.calmBees();
		}
		return super.onItemUseFirst(stack, player, world, pos, side, hitX, hitY, hitZ, hand);
	}

	@Override
	public int func_77626_a(ItemStack stack) {
		return 32;
	}

	@Nonnull
	@Override
	public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
		return new ICapabilityProvider() {
			@Override
			public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
				return capability == ApicultureCapabilities.ARMOR_APIARIST;
			}

			@Override
			public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
				if (capability == ApicultureCapabilities.ARMOR_APIARIST) {
					return capability.getDefaultInstance();
				}
				return null;
			}
		};
	}
}
