/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics.alleles;

import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.IAlleleTreeSpeciesBuilder;
import forestry.api.arboriculture.IGermlingModelProvider;
import forestry.api.arboriculture.ILeafSpriteProvider;
import forestry.api.arboriculture.ITreeGenerator;
import forestry.api.arboriculture.ITreeRoot;
import forestry.api.arboriculture.IWoodProvider;
import forestry.api.arboriculture.TreeManager;
import forestry.api.core.IModelManager;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IClassification;
import forestry.api.genetics.IFruitFamily;
import forestry.core.genetics.alleles.AlleleSpecies;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AlleleTreeSpecies
extends AlleleSpecies
implements IAlleleTreeSpeciesBuilder,
IAlleleTreeSpecies {
    @Nonnull
    private final ITreeGenerator generator;
    @Nonnull
    private final IWoodProvider woodProvider;
    @Nonnull
    private final IGermlingModelProvider germlingModelProvider;
    @Nonnull
    private final ILeafSpriteProvider leafSpriteProvider;
    @Nonnull
    private final List<IFruitFamily> fruits = new ArrayList<IFruitFamily>();
    @Nonnull
    private final String modID;
    @Nonnull
    private EnumPlantType nativeType = EnumPlantType.Plains;

    public AlleleTreeSpecies(@Nonnull String uid, @Nonnull String unlocalizedName, @Nonnull String authority, @Nonnull String unlocalizedDescription, boolean isDominant, @Nonnull IClassification branch, @Nonnull String binomial, @Nonnull String modID, @Nonnull ILeafSpriteProvider leafIconProvider, @Nonnull IGermlingModelProvider germlingModelProvider, @Nonnull IWoodProvider woodProvider, @Nonnull ITreeGenerator generator) {
        super(uid, unlocalizedName, authority, unlocalizedDescription, isDominant, branch, binomial);
        this.generator = generator;
        this.germlingModelProvider = germlingModelProvider;
        this.woodProvider = woodProvider;
        this.leafSpriteProvider = leafIconProvider;
        this.modID = modID;
    }

    @Override
    public IAlleleTreeSpecies build() {
        AlleleManager.alleleRegistry.registerAllele(this, EnumTreeChromosome.SPECIES);
        return this;
    }

    @Override
    @Nonnull
    public ITreeRoot getRoot() {
        return TreeManager.treeRoot;
    }

    @Override
    public AlleleTreeSpecies setPlantType(EnumPlantType type) {
        this.nativeType = type;
        return this;
    }

    @Override
    public AlleleTreeSpecies addFruitFamily(IFruitFamily family) {
        this.fruits.add(family);
        return this;
    }

    @Override
    @Nonnull
    public EnumPlantType getPlantType() {
        return this.nativeType;
    }

    @Nonnull
    public List<IFruitFamily> getSuitableFruit() {
        return this.fruits;
    }

    @Override
    @Nonnull
    public ITreeGenerator getGenerator() {
        return this.generator;
    }

    @Override
    @Nonnull
    public ILeafSpriteProvider getLeafSpriteProvider() {
        return this.leafSpriteProvider;
    }

    @Override
    public int getSpriteColour(int renderPass) {
        return this.leafSpriteProvider.getColor(false);
    }

    @Override
    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation getGermlingModel(EnumGermlingType type) {
        return this.germlingModelProvider.getModel(type);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getGermlingColour(EnumGermlingType type, int renderPass) {
        if (type != EnumGermlingType.POLLEN) {
            return 0xFFFFFF;
        }
        return this.getSpriteColour(renderPass);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(Item item, IModelManager manager, EnumGermlingType type) {
        this.germlingModelProvider.registerModels(item, manager, type);
    }

    @Override
    @Nonnull
    public IWoodProvider getWoodProvider() {
        return this.woodProvider;
    }

    @Override
    @Nonnull
    public String getModID() {
        return this.modID;
    }

    @Override
    public int compareTo(@Nonnull IAlleleTreeSpecies o) {
        return 0;
    }
}

