/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.climate;

import forestry.api.climate.IClimateControl;
import forestry.api.climate.IClimatePosition;
import forestry.api.climate.IClimateRegion;
import forestry.api.climate.IClimateSource;
import forestry.core.climate.BiomeClimateControl;
import forestry.core.climate.ClimatePosition;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IStreamable;
import forestry.core.utils.ClimateUtil;
import forestry.greenhouse.multiblock.IGreenhouseControllerInternal;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ClimateRoom
implements IClimateRegion,
IStreamable {
    protected final World world;
    protected final IGreenhouseControllerInternal controller;
    protected final Map<BlockPos, IClimatePosition> positions;
    protected final List<BlockPos> wallPositions;
    protected final List<IClimateSource> sources;
    protected float temperature;
    protected float humidity;

    public ClimateRoom(ClimateRoom oldRoom, Map<BlockPos, IClimatePosition> newPositions, List<BlockPos> newWallPositions) {
        this.world = oldRoom.getWorld();
        this.controller = oldRoom.controller;
        this.positions = new HashMap<BlockPos, IClimatePosition>();
        this.wallPositions = newWallPositions;
        this.sources = new ArrayList<IClimateSource>();
        for (Map.Entry<BlockPos, IClimatePosition> positionEntry : newPositions.entrySet()) {
            BlockPos pos = positionEntry.getKey();
            IClimatePosition position = positionEntry.getValue();
            IClimatePosition oldPosition = oldRoom.getPositions().get(pos);
            float temperature = position.getTemperature();
            float humidity = position.getHumidity();
            if (oldPosition != null) {
                temperature = oldPosition.getTemperature();
                humidity = oldPosition.getHumidity();
            }
            this.addPosition(pos, temperature, humidity);
        }
        this.temperature = this.getExactTemperature();
        this.humidity = this.getExactHumidity();
    }

    public ClimateRoom(IGreenhouseControllerInternal controller, Map<BlockPos, IClimatePosition> innerPositions, List<BlockPos> wallPositions) {
        this.world = controller.getWorldObj();
        this.controller = controller;
        this.positions = innerPositions;
        this.wallPositions = wallPositions;
        this.sources = new ArrayList<IClimateSource>();
        this.temperature = this.getExactTemperature();
        this.humidity = this.getExactHumidity();
    }

    public ClimateRoom(IGreenhouseControllerInternal controller, List<BlockPos> wallPositions, NBTTagCompound nbtTag) {
        this.world = controller.getWorldObj();
        this.controller = controller;
        this.positions = new HashMap<BlockPos, IClimatePosition>();
        this.wallPositions = new ArrayList<BlockPos>();
        this.sources = new ArrayList<IClimateSource>();
        this.readFromNBT(nbtTag);
        this.temperature = this.getExactTemperature();
        this.humidity = this.getExactHumidity();
    }

    private float getExactTemperature() {
        float temperature = 0.0f;
        int positions = 0;
        for (IClimatePosition position : this.positions.values()) {
            if (position == null) continue;
            ++positions;
            temperature += position.getTemperature();
        }
        return temperature / (float)positions;
    }

    private float getExactHumidity() {
        float humidity = 0.0f;
        int positions = 0;
        for (IClimatePosition position : this.positions.values()) {
            if (position == null) continue;
            ++positions;
            humidity += position.getHumidity();
        }
        return humidity / (float)positions;
    }

    @Override
    public void updateClimate(int ticks) {
        for (IClimateSource iClimateSource : this.sources) {
            if (iClimateSource == null || ticks % iClimateSource.getTicksForChange(this) != 0) continue;
            iClimateSource.changeClimate(ticks, this);
        }
        if (ticks % this.getTicksPerUpdate() == 0) {
            for (Map.Entry entry : this.positions.entrySet()) {
                BlockPos pos = (BlockPos)entry.getKey();
                if (!this.world.func_175667_e(pos)) continue;
                this.updateSides(pos);
                if (this.controller.isAssembled()) continue;
                IClimateControl climateControl = this.getControl(pos);
                IClimatePosition climatedInfo = this.positions.get(pos);
                if (climatedInfo.getTemperature() != climateControl.getControlTemperature()) {
                    if (climatedInfo.getTemperature() > climateControl.getControlTemperature()) {
                        climatedInfo.addTemperature(-Math.min(0.01f, climatedInfo.getTemperature() - climateControl.getControlTemperature()));
                    } else {
                        climatedInfo.addTemperature(Math.min(0.01f, climateControl.getControlTemperature() - climatedInfo.getTemperature()));
                    }
                }
                if (climatedInfo.getHumidity() == climateControl.getControlHumidity()) continue;
                if (climatedInfo.getHumidity() > climateControl.getControlHumidity()) {
                    climatedInfo.addHumidity(-Math.min(0.01f, climatedInfo.getHumidity() - climateControl.getControlHumidity()));
                    continue;
                }
                climatedInfo.addHumidity(Math.min(0.01f, climateControl.getControlHumidity() - climatedInfo.getHumidity()));
            }
        }
    }

    protected void updateSides(BlockPos pos) {
        IClimatePosition climatedInfo = this.positions.get(pos);
        IClimateControl climateControl = this.getControl(pos);
        boolean hasChange = false;
        if (climateControl.getControlTemperature() != this.temperature || climateControl.getControlHumidity() != this.humidity) {
            boolean updateHum;
            boolean updateTemp = climatedInfo.getTemperature() >= climateControl.getControlTemperature();
            boolean bl = updateHum = climatedInfo.getHumidity() >= climateControl.getControlHumidity();
            if (updateTemp || updateHum) {
                for (EnumFacing facing : EnumFacing.field_82609_l) {
                    float change;
                    IClimatePosition climatedInfoFace = this.positions.get(pos.func_177972_a(facing));
                    if (climatedInfoFace == null) continue;
                    if (climatedInfo.getTemperature() > climatedInfoFace.getTemperature() + 0.01f) {
                        change = Math.min(0.01f, climatedInfo.getTemperature() - climatedInfoFace.getTemperature());
                        climatedInfo.addTemperature(-change);
                        climatedInfoFace.addTemperature(change);
                        updateTemp = climatedInfo.getTemperature() >= climateControl.getControlTemperature();
                        hasChange = true;
                    }
                    if (climatedInfo.getHumidity() > climatedInfoFace.getHumidity() + 0.01f) {
                        change = Math.min(0.01f, climatedInfo.getHumidity() - climatedInfoFace.getHumidity());
                        climatedInfo.addHumidity(-change);
                        climatedInfoFace.addHumidity(change);
                        updateHum = climatedInfo.getTemperature() >= climateControl.getControlTemperature();
                        hasChange = true;
                    }
                    if (!updateTemp && !updateHum) break;
                }
            }
        }
        if (hasChange) {
            this.temperature = this.getExactTemperature();
            this.humidity = this.getExactHumidity();
        }
    }

    protected IClimateControl getControl(BlockPos pos) {
        if (this.world.func_175667_e(pos) && !this.controller.isAssembled()) {
            return BiomeClimateControl.getControl(this.world.func_180494_b(pos));
        }
        return this.controller.getClimateControl();
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTTagList positionList = new NBTTagList();
        for (Map.Entry<BlockPos, IClimatePosition> entry : this.positions.entrySet()) {
            BlockPos pos = entry.getKey();
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("X", pos.func_177958_n());
            tag.func_74768_a("Y", pos.func_177956_o());
            tag.func_74768_a("Z", pos.func_177952_p());
            positionList.func_74742_a((NBTBase)entry.getValue().writeToNBT(tag));
        }
        nbt.func_74782_a("Positions", (NBTBase)positionList);
        return nbt;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        NBTTagList positionList = nbt.func_150295_c("Positions", 10);
        for (int i = 0; i < positionList.func_74745_c(); ++i) {
            int zPos;
            int yPos;
            NBTTagCompound positionTag = positionList.func_150305_b(i);
            int xPos = positionTag.func_74762_e("X");
            BlockPos pos = new BlockPos(xPos, yPos = positionTag.func_74762_e("Y"), zPos = positionTag.func_74762_e("Z"));
            IClimatePosition position = this.positions.get(pos);
            if (position != null) {
                position.readFromNBT(positionTag);
                continue;
            }
            this.positions.put(pos, new ClimatePosition(this, pos, positionTag));
        }
    }

    @Override
    public int getTicksPerUpdate() {
        return 20;
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    @Override
    public Map<BlockPos, IClimatePosition> getPositions() {
        return this.positions;
    }

    public synchronized void addPosition(BlockPos pos, float temperature, float humidity) {
        IClimatePosition otherPosition = this.positions.get(pos);
        if (otherPosition != null) {
            otherPosition.setHumidity(humidity);
            otherPosition.setTemperature(temperature);
        } else {
            this.positions.put(pos, new ClimatePosition(this, pos, temperature, humidity));
        }
    }

    @Override
    public synchronized void addSource(IClimateSource source) {
        if (!this.sources.contains(source)) {
            this.sources.add(source);
        }
    }

    @Override
    public synchronized void removeSource(IClimateSource source) {
        if (this.sources.contains(source)) {
            this.sources.remove(source);
        }
    }

    @Override
    public Collection<IClimateSource> getSources() {
        return this.sources;
    }

    public List<BlockPos> getOtherPositions() {
        return this.wallPositions;
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        if (!this.positions.isEmpty()) {
            data.writeInt(this.positions.size());
            for (IClimatePosition pos : this.positions.values()) {
                ClimateUtil.writeRoomPositionData(pos, data);
            }
            data.writeFloat(this.temperature);
            data.writeFloat(this.humidity);
        } else {
            data.writeInt(0);
        }
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        int size = data.readInt();
        if (size != 0) {
            this.positions.clear();
            for (int index = 0; index < size; ++index) {
                ClimateUtil.readRoomPositionData(this, data);
            }
            this.temperature = data.readFloat();
            this.humidity = data.readFloat();
        }
    }

    @Override
    public float getTemperature() {
        return this.temperature;
    }

    @Override
    public float getHumidity() {
        return this.humidity;
    }
}

