/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes;

import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class BottlerRecipe {
    public final FluidStack input;
    public final ItemStack empty;
    public final ItemStack filled;
    public final boolean fillRecipe;

    public static BottlerRecipe createFilled(ItemStack filled) {
        if (filled == null) {
            return null;
        }
        ItemStack empty = filled.func_77946_l();
        empty.field_77994_a = 1;
        IFluidHandler fluidHandler = FluidUtil.getFluidHandler((ItemStack)empty);
        if (fluidHandler == null) {
            return null;
        }
        FluidStack fill = fluidHandler.drain(Integer.MAX_VALUE, true);
        if (fill != null && fill.amount > 0) {
            return new BottlerRecipe(empty, fill, filled, false);
        }
        return null;
    }

    public static BottlerRecipe createEmpty(Fluid res, ItemStack empty) {
        if (res == null || empty == null) {
            return null;
        }
        ItemStack filled = empty.func_77946_l();
        filled.field_77994_a = 1;
        IFluidHandler fluidHandler = FluidUtil.getFluidHandler((ItemStack)filled);
        if (fluidHandler == null) {
            return null;
        }
        int fillAmount = fluidHandler.fill(new FluidStack(res, Integer.MAX_VALUE), true);
        if (fillAmount > 0) {
            return new BottlerRecipe(empty, new FluidStack(res, fillAmount), filled, true);
        }
        return null;
    }

    private BottlerRecipe(ItemStack empty, FluidStack input, ItemStack filled, boolean fillRecipe) {
        this.input = input;
        this.empty = empty;
        this.filled = filled;
        this.fillRecipe = fillRecipe;
    }

    public boolean matcheEmpty(ItemStack emptyCan, FluidStack resource) {
        return emptyCan != null && resource != null && emptyCan.func_77969_a(this.empty) && resource.containsFluid(this.input) && this.fillRecipe;
    }

    public boolean matcheFilled(ItemStack filledCan) {
        return this.filled != null && !this.fillRecipe && this.filled.func_77969_a(filledCan);
    }
}

