/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IApiaristTracker;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeHousingInventory;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.arboriculture.ITree;
import forestry.api.core.IErrorLogic;
import forestry.api.core.IErrorState;
import forestry.api.genetics.IEffectData;
import forestry.api.genetics.IIndividual;
import forestry.apiculture.HasFlowersCache;
import forestry.apiculture.PluginApiculture;
import forestry.apiculture.network.packets.PacketBeeLogicActive;
import forestry.apiculture.network.packets.PacketBeeLogicActiveEntity;
import forestry.core.errors.EnumErrorCode;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IStreamable;
import forestry.core.proxy.Proxies;
import forestry.core.utils.Log;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BeekeepingLogic
implements IBeekeepingLogic,
IStreamable {
    private static final int totalBreedingTime = 100;
    private final IBeeHousing housing;
    private final IBeeModifier beeModifier;
    private final IBeeListener beeListener;
    private int beeProgress;
    private int beeProgressMax;
    private int queenWorkCycleThrottle;
    private IEffectData[] effectData = new IEffectData[2];
    private final Stack<ItemStack> spawn = new Stack();
    private final HasFlowersCache hasFlowersCache = new HasFlowersCache();
    private final QueenCanWorkCache queenCanWorkCache = new QueenCanWorkCache();
    private final PollenHandler pollenHandler = new PollenHandler();
    private boolean active;
    private IBee queen;
    private ItemStack queenStack;

    public BeekeepingLogic(IBeeHousing housing) {
        this.housing = housing;
        this.beeModifier = BeeManager.beeRoot.createBeeHousingModifier(housing);
        this.beeListener = BeeManager.beeRoot.createBeeHousingListener(housing);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.beeProgress = nbttagcompound.func_74762_e("BreedingTime");
        this.queenWorkCycleThrottle = nbttagcompound.func_74762_e("Throttle");
        NBTTagCompound queenNBT = nbttagcompound.func_74775_l("queen");
        this.queenStack = ItemStack.func_77949_a((NBTTagCompound)queenNBT);
        this.queen = BeeManager.beeRoot.getMember(this.queenStack);
        this.setActive(nbttagcompound.func_74767_n("Active"));
        this.hasFlowersCache.readFromNBT(nbttagcompound);
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("Offspring", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            this.spawn.add(ItemStack.func_77949_a((NBTTagCompound)nbttaglist.func_150305_b(i)));
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74768_a("BreedingTime", this.beeProgress);
        nbttagcompound.func_74768_a("Throttle", this.queenWorkCycleThrottle);
        if (this.queenStack != null) {
            NBTTagCompound queenNBT = new NBTTagCompound();
            this.queenStack.func_77955_b(queenNBT);
            nbttagcompound.func_74782_a("queen", (NBTBase)queenNBT);
        }
        nbttagcompound.func_74757_a("Active", this.active);
        this.hasFlowersCache.writeToNBT(nbttagcompound);
        Stack<ItemStack> spawnCopy = new Stack<ItemStack>();
        spawnCopy.addAll(this.spawn);
        NBTTagList nbttaglist = new NBTTagList();
        while (!spawnCopy.isEmpty()) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            ((ItemStack)spawnCopy.pop()).func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("Offspring", (NBTBase)nbttaglist);
        return nbttagcompound;
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        data.writeBoolean(this.active);
        if (this.active) {
            data.writeItemStack(this.queenStack);
            this.hasFlowersCache.writeData(data);
        }
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        boolean active = data.readBoolean();
        this.setActive(active);
        if (active) {
            this.queenStack = data.readItemStack();
            this.queen = BeeManager.beeRoot.getMember(this.queenStack);
            this.hasFlowersCache.readData(data);
        }
    }

    private void setActive(boolean active) {
        if (this.active == active) {
            return;
        }
        this.active = active;
        this.syncToClient();
    }

    @Override
    public boolean canWork() {
        boolean canWork;
        IErrorLogic errorLogic = this.housing.getErrorLogic();
        errorLogic.clearErrors();
        IBeeHousingInventory beeInventory = this.housing.getBeeInventory();
        boolean hasSpace = BeekeepingLogic.addPendingProducts(beeInventory, this.spawn);
        errorLogic.setCondition(!hasSpace, EnumErrorCode.NO_SPACE_INVENTORY);
        ItemStack queenStack = beeInventory.getQueen();
        EnumBeeType beeType = BeeManager.beeRoot.getType(queenStack);
        if (beeType == EnumBeeType.PRINCESS) {
            boolean hasDrone = BeeManager.beeRoot.isDrone(beeInventory.getDrone());
            errorLogic.setCondition(!hasDrone, EnumErrorCode.NO_DRONE);
            this.setActive(false);
            return !errorLogic.hasErrors();
        }
        if (beeType == EnumBeeType.QUEEN) {
            if (!BeekeepingLogic.isQueenAlive(queenStack)) {
                IBee dyingQueen = BeeManager.beeRoot.getMember(queenStack);
                Collection<ItemStack> spawned = BeekeepingLogic.killQueen(dyingQueen, this.housing, this.beeListener);
                this.spawn.addAll(spawned);
                queenStack = null;
            }
        } else {
            queenStack = null;
        }
        if (this.queenStack != queenStack) {
            this.queen = BeeManager.beeRoot.getMember(queenStack);
            this.queenStack = queenStack;
            this.hasFlowersCache.clear();
            this.queenCanWorkCache.clear();
        }
        if (errorLogic.setCondition(this.queen == null, EnumErrorCode.NO_QUEEN)) {
            this.setActive(false);
            this.beeProgress = 0;
            return false;
        }
        Set<IErrorState> queenErrors = this.queenCanWorkCache.queenCanWork(this.queen, this.housing);
        for (IErrorState errorState : queenErrors) {
            errorLogic.setCondition(true, errorState);
        }
        boolean hasFlowers = this.hasFlowersCache.hasFlowers(this.queen, this.housing);
        boolean flowerCacheNeedsSync = this.hasFlowersCache.needsSync();
        errorLogic.setCondition(!hasFlowers, EnumErrorCode.NO_FLOWER);
        boolean bl = canWork = !errorLogic.hasErrors();
        if (this.active != canWork) {
            this.setActive(canWork);
        } else if (flowerCacheNeedsSync) {
            this.syncToClient();
        }
        return canWork;
    }

    @Override
    public void doWork() {
        IBeeHousingInventory beeInventory = this.housing.getBeeInventory();
        ItemStack queenStack = beeInventory.getQueen();
        EnumBeeType beeType = BeeManager.beeRoot.getType(queenStack);
        if (beeType == EnumBeeType.PRINCESS) {
            this.tickBreed();
        } else if (beeType == EnumBeeType.QUEEN) {
            this.queenWorkTick(this.queen, queenStack);
        }
    }

    @Override
    public void clearCachedValues() {
        if (!this.housing.getWorldObj().field_72995_K) {
            this.hasFlowersCache.clear();
            this.queenCanWorkCache.clear();
            this.canWork();
        }
    }

    private void queenWorkTick(@Nullable IBee queen, @Nonnull ItemStack queenStack) {
        if (queen == null) {
            this.beeProgress = 0;
            this.beeProgressMax = 0;
            return;
        }
        this.effectData = queen.doEffect(this.effectData, this.housing);
        ++this.queenWorkCycleThrottle;
        if (this.queenWorkCycleThrottle >= 550) {
            this.queenWorkCycleThrottle = 0;
            BeekeepingLogic.doProduction(queen, this.housing, this.beeListener);
            queen.plantFlowerRandom(this.housing);
            this.pollenHandler.doPollination(queen, this.housing, this.beeListener);
            float lifespanModifier = this.beeModifier.getLifespanModifier(queen.getGenome(), queen.getMate(), 1.0f);
            queen.age(this.housing.getWorldObj(), lifespanModifier);
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            queen.writeToNBT(nbttagcompound);
            queenStack.func_77982_d(nbttagcompound);
            this.housing.getBeeInventory().setQueen(queenStack);
        }
        this.beeProgress = queen.getHealth();
        this.beeProgressMax = queen.getMaxHealth();
    }

    private static void doProduction(IBee queen, IBeeHousing beeHousing, IBeeListener beeListener) {
        ItemStack[] products = queen.produceStacks(beeHousing);
        if (products == null) {
            return;
        }
        beeListener.wearOutEquipment(1);
        IBeeHousingInventory beeInventory = beeHousing.getBeeInventory();
        for (ItemStack stack : products) {
            beeInventory.addProduct(stack, false);
        }
    }

    private static boolean addPendingProducts(IBeeHousingInventory beeInventory, Stack<ItemStack> spawn) {
        boolean housingHasSpace = true;
        while (!spawn.isEmpty()) {
            ItemStack next = spawn.peek();
            if (beeInventory.addProduct(next, true)) {
                spawn.pop();
                continue;
            }
            housingHasSpace = false;
            break;
        }
        return housingHasSpace;
    }

    private static boolean isQueenAlive(ItemStack queenStack) {
        if (queenStack == null) {
            return false;
        }
        NBTTagCompound nbtTagCompound = queenStack.func_77978_p();
        if (nbtTagCompound == null) {
            return false;
        }
        int health = nbtTagCompound.func_74762_e("Health");
        return health > 0;
    }

    private void tickBreed() {
        this.beeProgressMax = 100;
        IBeeHousingInventory beeInventory = this.housing.getBeeInventory();
        ItemStack droneStack = beeInventory.getDrone();
        ItemStack princessStack = beeInventory.getQueen();
        EnumBeeType droneType = BeeManager.beeRoot.getType(droneStack);
        EnumBeeType princessType = BeeManager.beeRoot.getType(princessStack);
        if (droneType != EnumBeeType.DRONE || princessType != EnumBeeType.PRINCESS) {
            this.beeProgress = 0;
            return;
        }
        if (this.beeProgress < 100) {
            ++this.beeProgress;
        }
        if (this.beeProgress < 100) {
            return;
        }
        IBee princess = BeeManager.beeRoot.getMember(princessStack);
        IBee drone = BeeManager.beeRoot.getMember(droneStack);
        princess.mate(drone);
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        princess.writeToNBT(nbttagcompound);
        this.queenStack = new ItemStack((Item)PluginApiculture.items.beeQueenGE);
        this.queenStack.func_77982_d(nbttagcompound);
        beeInventory.setQueen(this.queenStack);
        BeeManager.beeRoot.getBreedingTracker(this.housing.getWorldObj(), this.housing.getOwner()).registerQueen(princess);
        --beeInventory.getDrone().field_77994_a;
        if (beeInventory.getDrone().field_77994_a <= 0) {
            beeInventory.setDrone(null);
        }
        this.queen = princess;
        this.beeProgress = princess.getHealth();
        this.beeProgressMax = princess.getMaxHealth();
    }

    private static Collection<ItemStack> killQueen(IBee queen, IBeeHousing beeHousing, IBeeListener beeListener) {
        Collection<ItemStack> spawn;
        if (queen == null) {
            return Collections.emptySet();
        }
        IBeeHousingInventory beeInventory = beeHousing.getBeeInventory();
        if (queen.canSpawn()) {
            spawn = BeekeepingLogic.spawnOffspring(queen, beeHousing);
            beeListener.onQueenDeath();
            beeInventory.getQueen().field_77994_a = 0;
            beeInventory.setQueen(null);
        } else {
            Log.warning("Tried to spawn offspring off an unmated queen. Devolving her to a princess.", new Object[0]);
            ItemStack convert = new ItemStack((Item)PluginApiculture.items.beePrincessGE);
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            queen.writeToNBT(nbttagcompound);
            convert.func_77982_d(nbttagcompound);
            spawn = Collections.singleton(convert);
            beeInventory.setQueen(null);
        }
        return spawn;
    }

    private static Collection<ItemStack> spawnOffspring(IBee queen, IBeeHousing beeHousing) {
        ItemStack drones;
        int count;
        World world = beeHousing.getWorldObj();
        Stack<ItemStack> offspring = new Stack<ItemStack>();
        IApiaristTracker breedingTracker = BeeManager.beeRoot.getBreedingTracker(world, beeHousing.getOwner());
        boolean secondPrincess = (double)world.field_73012_v.nextInt(10000) < PluginApiculture.getSecondPrincessChance() * 100.0;
        int n = count = secondPrincess ? 2 : 1;
        while (count > 0) {
            --count;
            IBee heiress = queen.spawnPrincess(beeHousing);
            if (heiress == null) continue;
            ItemStack princess = BeeManager.beeRoot.getMemberStack(heiress, EnumBeeType.PRINCESS);
            breedingTracker.registerPrincess(heiress);
            offspring.push(princess);
        }
        for (ItemStack drone : drones = queen.spawnDrones(beeHousing)) {
            ItemStack droneStack = BeeManager.beeRoot.getMemberStack((IIndividual)drone, EnumBeeType.DRONE);
            breedingTracker.registerDrone((IIndividual)drone);
            offspring.push(droneStack);
        }
        IBeeHousingInventory beeInventory = beeHousing.getBeeInventory();
        ArrayList<ItemStack> spawn = new ArrayList<ItemStack>();
        while (!offspring.isEmpty()) {
            ItemStack spawned = (ItemStack)offspring.pop();
            if (beeInventory.addProduct(spawned, true)) continue;
            spawn.add(spawned);
        }
        return spawn;
    }

    @Override
    public void syncToClient() {
        World world = this.housing.getWorldObj();
        if (world != null && !world.field_72995_K) {
            if (this.housing instanceof Entity) {
                Proxies.net.sendNetworkPacket(new PacketBeeLogicActiveEntity(this.housing, (Entity)this.housing), world);
            } else {
                Proxies.net.sendNetworkPacket(new PacketBeeLogicActive(this.housing), world);
            }
        }
    }

    @Override
    public void syncToClient(EntityPlayerMP player) {
        World world = this.housing.getWorldObj();
        if (world != null && !world.field_72995_K) {
            if (this.housing instanceof TileEntity) {
                Proxies.net.sendToPlayer(new PacketBeeLogicActive(this.housing), (EntityPlayer)player);
            } else if (this.housing instanceof Entity) {
                Proxies.net.sendToPlayer(new PacketBeeLogicActiveEntity(this.housing, (Entity)this.housing), (EntityPlayer)player);
            }
        }
    }

    @Override
    public int getBeeProgressPercent() {
        if (this.beeProgressMax == 0) {
            return 0;
        }
        return Math.round((float)this.beeProgress * 100.0f / (float)this.beeProgressMax);
    }

    @Override
    public boolean canDoBeeFX() {
        return this.active;
    }

    @Override
    public void doBeeFX() {
        if (this.queen != null) {
            this.queen.doFX(this.effectData, this.housing);
        }
    }

    @Override
    @Nonnull
    public List<BlockPos> getFlowerPositions() {
        return this.hasFlowersCache.getFlowerCoords();
    }

    private static class PollenHandler {
        private static final int MAX_POLLINATION_ATTEMPTS = 20;
        private ITree pollen;
        private int attemptedPollinations = 0;

        private PollenHandler() {
        }

        public void doPollination(IBee queen, IBeeHousing beeHousing, IBeeListener beeListener) {
            if (this.pollen == null) {
                this.attemptedPollinations = 0;
                this.pollen = queen.retrievePollen(beeHousing);
                if (this.pollen != null && beeListener.onPollenRetrieved(this.pollen)) {
                    this.pollen = null;
                }
            }
            if (this.pollen != null) {
                ++this.attemptedPollinations;
                if (queen.pollinateRandom(beeHousing, this.pollen) || this.attemptedPollinations >= 20) {
                    this.pollen = null;
                }
            }
        }
    }

    private static class QueenCanWorkCache {
        private static final int ticksPerCheckQueenCanWork = 10;
        private Set<IErrorState> queenCanWorkCached = Collections.emptySet();
        private int queenCanWorkCooldown = 0;

        private QueenCanWorkCache() {
        }

        public Set<IErrorState> queenCanWork(IBee queen, IBeeHousing beeHousing) {
            if (this.queenCanWorkCooldown <= 0) {
                this.queenCanWorkCached = queen.getCanWork(beeHousing);
                this.queenCanWorkCooldown = 10;
            } else {
                --this.queenCanWorkCooldown;
            }
            return this.queenCanWorkCached;
        }

        public void clear() {
            this.queenCanWorkCached.clear();
            this.queenCanWorkCooldown = 0;
        }
    }
}

