/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.apiculture.render;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;

import forestry.api.apiculture.EnumBeeType;

public class ModelBee extends ModelBase {

	//fields
	private final ModelRenderer snout;
	private final ModelRenderer torsoWing;
	private final ModelRenderer rump;
	private final ModelRenderer tail;
	private final ModelRenderer tailEnd;
	private final ModelRenderer bridge;
	private final ModelRenderer eyeRight;
	private final ModelRenderer eyeLeft;
	private final ModelRenderer wingLeft;
	private final ModelRenderer wingRight;
	private final ModelRenderer crownQueen;
	private final ModelRenderer crownPrincess;

	private EnumBeeType type = EnumBeeType.DRONE;

	public ModelBee() {
		field_78090_t = 64;
		field_78089_u = 32;

		snout = new ModelRenderer(this, 18, 11);
		snout.func_78789_a(0F, 0F, 0F, 1, 2, 1);
		snout.func_78793_a(0F, 1F, -2F);
		snout.func_78787_b(64, 32);
		snout.field_78809_i = true;
		setRotation(snout, 0F, 0F, 0F);
		torsoWing = new ModelRenderer(this, 28, 14);
		torsoWing.func_78789_a(0F, 0F, 0F, 3, 3, 1);
		torsoWing.func_78793_a(-1F, 0F, -1F);
		torsoWing.func_78787_b(64, 32);
		torsoWing.field_78809_i = true;
		setRotation(torsoWing, 0F, 0F, 0F);
		rump = new ModelRenderer(this, 10, 14);
		rump.func_78789_a(-1F, -1F, 0F, 3, 3, 3);
		rump.func_78793_a(0F, 1F, 1F);
		rump.func_78787_b(64, 32);
		rump.field_78809_i = true;
		setRotation(rump, 0F, 0F, 0F);
		tail = new ModelRenderer(this, 4, 14);
		tail.func_78789_a(0F, 0F, 0F, 2, 2, 1);
		tail.func_78793_a(-0.5F, 0.5333334F, 4F);
		tail.func_78787_b(64, 32);
		tail.field_78809_i = true;
		setRotation(tail, 0F, 0F, 0F);
		tailEnd = new ModelRenderer(this, 0, 14);
		tailEnd.func_78789_a(0F, 0F, 0F, 1, 1, 1);
		tailEnd.func_78793_a(0F, 1F, 5F);
		tailEnd.func_78787_b(64, 32);
		tailEnd.field_78809_i = true;
		setRotation(tailEnd, 0F, 0F, 0F);
		bridge = new ModelRenderer(this, 22, 14);
		bridge.func_78789_a(0F, 0F, 0F, 2, 2, 1);
		bridge.func_78793_a(-0.5F, 0.5F, 0F);
		bridge.func_78787_b(64, 32);
		bridge.field_78809_i = true;
		setRotation(bridge, 0F, 0F, 0F);
		eyeRight = new ModelRenderer(this, 22, 9);
		eyeRight.func_78789_a(0F, 0F, 0F, 1, 1, 1);
		eyeRight.func_78793_a(-1F, 0F, -2F);
		eyeRight.func_78787_b(64, 32);
		eyeRight.field_78809_i = true;
		setRotation(eyeRight, 0F, 0F, 0F);
		eyeLeft = new ModelRenderer(this, 18, 9);
		eyeLeft.func_78789_a(0F, 0F, 0F, 1, 1, 1);
		eyeLeft.func_78793_a(1F, 0F, -2F);
		eyeLeft.func_78787_b(64, 32);
		eyeLeft.field_78809_i = true;
		setRotation(eyeLeft, 0F, 0F, 0F);
		wingLeft = new ModelRenderer(this, 0, 0);
		wingLeft.func_78789_a(0F, 0F, 0F, 3, 1, 6);
		wingLeft.func_78793_a(1F, -0.1F, -0.5F);
		wingLeft.func_78787_b(64, 32);
		wingLeft.field_78809_i = true;
		setRotation(wingLeft, 0F, 0.1396263F, 0F);
		wingRight = new ModelRenderer(this, 0, 7);
		wingRight.func_78789_a(-3F, 0F, 0F, 3, 1, 6);
		wingRight.func_78793_a(0F, -0.1F, -0.5F);
		wingRight.func_78787_b(64, 32);
		wingRight.field_78809_i = true;
		setRotation(wingRight, 0F, -0.1396263F, 0F);

		crownQueen = new ModelRenderer(this, 0, 17);
		crownQueen.func_78789_a(0F, 0F, 0F, 2, 1, 2);
		crownQueen.func_78793_a(-0.5F, -1.5F, -1.5F);
		crownQueen.func_78787_b(64, 32);
		crownQueen.field_78809_i = true;
		setRotation(crownQueen, 0F, 0F, 0F);

		crownPrincess = new ModelRenderer(this, 0, 20);
		crownPrincess.func_78789_a(0F, 0F, 0F, 2, 1, 2);
		crownPrincess.func_78793_a(-0.5F, -1.5F, -1.5F);
		crownPrincess.func_78787_b(64, 32);
		crownPrincess.field_78809_i = true;
		setRotation(crownPrincess, 0F, 0F, 0F);

	}

	public void setType(EnumBeeType type) {
		this.type = type;
	}

	@Override
	public void func_78088_a(Entity entity, float f, float f1, float swing, float f3, float f4, float f5) {
		super.func_78088_a(entity, f, f1, swing, f3, f4, f5);
		//setRotationAngles(f, f1, f2, f3, f4, f5, entity);

		wingRight.field_78808_h = MathHelper.func_76134_b(swing * 1.3F) * (float) Math.PI * 0.25F;
		wingLeft.field_78808_h = -wingRight.field_78808_h;

		GlStateManager.func_179094_E();
		float scale = 0.75f;
		GlStateManager.func_179152_a(scale, scale, scale);
		GlStateManager.func_179109_b(0.0F, 12.0f / scale * f5, 0.0F);

		snout.func_78785_a(f5);
		torsoWing.func_78785_a(f5);
		rump.func_78785_a(f5);
		tail.func_78785_a(f5);
		tailEnd.func_78785_a(f5);
		bridge.func_78785_a(f5);
		eyeRight.func_78785_a(f5);
		eyeLeft.func_78785_a(f5);
		wingLeft.func_78785_a(f5);
		wingRight.func_78785_a(f5);

		if (type == EnumBeeType.PRINCESS) {
			crownPrincess.func_78785_a(f5);
		} else if (type == EnumBeeType.QUEEN) {
			crownQueen.func_78785_a(f5);
		}

		GlStateManager.func_179121_F();
	}

	private static void setRotation(ModelRenderer model, float x, float y, float z) {
		model.field_78795_f = x;
		model.field_78796_g = y;
		model.field_78808_h = z;
	}

}
