/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.core.entities;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

import forestry.core.inventory.IInventoryAdapter;
import forestry.core.tiles.IFilterSlotDelegate;
import forestry.core.utils.InventoryUtil;

public abstract class EntityMinecartContainerForestry extends EntityMinecartForestry implements ISidedInventory, IFilterSlotDelegate {
	/**
	 * When set to true, the minecart will drop all items when setDead() is called. When false (such as when travelling
	 * dimensions) it preserves its contents.
	 */
	private boolean dropContentsWhenDead = true;

	@SuppressWarnings("unused")
	public EntityMinecartContainerForestry(World world) {
		super(world);
	}

	public EntityMinecartContainerForestry(World world, double posX, double posY, double posZ) {
		super(world, posX, posY, posZ);
	}

	@Override
	protected void func_70037_a(NBTTagCompound nbtTagCompound) {
		super.func_70037_a(nbtTagCompound);
		getInternalInventory().readFromNBT(nbtTagCompound);
	}

	@Override
	protected void func_70014_b(NBTTagCompound nbtTagCompound) {
		super.func_70014_b(nbtTagCompound);
		getInternalInventory().writeToNBT(nbtTagCompound);
	}

	@Override
	public void func_70106_y() {
		if (dropContentsWhenDead && !field_70170_p.field_72995_K) {
			InventoryUtil.dropInventory(getInternalInventory(), field_70170_p, field_70165_t, field_70163_u, field_70161_v);
		}
		super.func_70106_y();
	}

	@Override
	protected void func_94101_h() {
		int redstoneLevel = 15 - Container.func_94526_b(this);
		double drag = 0.98F + redstoneLevel * 0.001F;
		this.field_70159_w *= drag;
		this.field_70181_x *= 0.0D;
		this.field_70179_y *= drag;
	}

	@Override
	public Entity func_184204_a(int dimensionIn) {
		this.dropContentsWhenDead = false;
		return super.func_184204_a(dimensionIn);
	}

	/* IInventory */
	@Override
	public boolean func_70300_a(EntityPlayer player) {
		return !field_70128_L && player.func_70068_e(this) <= 64.0D;
	}

	@Override
	public int func_70302_i_() {
		return getInternalInventory().func_70302_i_();
	}

	@Override
	public final ItemStack func_70301_a(int slotIndex) {
		return getInternalInventory().func_70301_a(slotIndex);
	}

	@Override
	public ItemStack func_70298_a(int slotIndex, int amount) {
		return getInternalInventory().func_70298_a(slotIndex, amount);
	}
	
	@Override
	public ItemStack func_70304_b(int slotIndex) {
		return getInternalInventory().func_70304_b(slotIndex);
	}

	@Override
	public void func_70299_a(int slotIndex, ItemStack itemstack) {
		getInternalInventory().func_70299_a(slotIndex, itemstack);
	}

	@Override
	public final int func_70297_j_() {
		return getInternalInventory().func_70297_j_();
	}

	@Override
	public final void func_174889_b(EntityPlayer player) {
		getInternalInventory().func_174889_b(player);
	}

	@Override
	public final void func_174886_c(EntityPlayer player) {
		getInternalInventory().func_174886_c(player);
	}
	
	@Override
	public ITextComponent func_145748_c_() {
		return getInternalInventory().func_145748_c_();
	}
	
	@Override
	public boolean func_145818_k_() {
		return false;
	}

	@Override
	public final boolean func_94041_b(int slotIndex, ItemStack itemStack) {
		return getInternalInventory().func_94041_b(slotIndex, itemStack);
	}

	@Override
	public final boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
		return getInternalInventory().canSlotAccept(slotIndex, itemStack);
	}

	@Override
	public boolean isLocked(int slotIndex) {
		return getInternalInventory().isLocked(slotIndex);
	}
	
	@Override
	public int[] func_180463_a(EnumFacing side) {
		return getInternalInventory().func_180463_a(side);
	}

	@Override
	public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
		return getInternalInventory().func_180462_a(slot, stack, side);
	}

	@Override
	public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
		return getInternalInventory().func_180461_b(slot, stack, side);
	}

	@Override
	public void func_70296_d() {

	}

	protected abstract IInventoryAdapter getInternalInventory();

	@Override
	public int func_174887_a_(int id) {
		return getInternalInventory().func_174887_a_(id);
	}

	@Override
	public void func_174885_b(int id, int value) {
		getInternalInventory().func_174885_b(id, value);
	}

	@Override
	public int func_174890_g() {
		return getInternalInventory().func_174890_g();
	}

	@Override
	public void func_174888_l() {
		getInternalInventory().func_174888_l();
	}
}
