/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.climate;

import forestry.api.climate.IClimateRegion;
import forestry.api.core.ForestryAPI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ClimateEventHandler {
    Map<Integer, Integer> serverTicks = new HashMap<Integer, Integer>();

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        Integer dim = event.world.field_73011_w.getDimension();
        if (event.phase == TickEvent.Phase.END) {
            if (!this.serverTicks.containsKey(dim)) {
                this.serverTicks.put(dim, 1);
            }
            int ticks = this.serverTicks.get(dim);
            Map<Integer, List<IClimateRegion>> regions = ForestryAPI.climateManager.getRegions();
            if (regions != null && regions.containsKey(dim)) {
                for (IClimateRegion region : regions.get(dim)) {
                    region.updateClimate(ticks);
                }
            }
            this.serverTicks.put(dim, ticks + 1);
        }
    }
}

