/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.core.gui;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

import forestry.core.gui.slots.SlotLocked;
import forestry.core.inventory.ItemInventory;

public abstract class ContainerItemInventory<I extends ItemInventory> extends ContainerForestry {

	protected final I inventory;

	protected ContainerItemInventory(I inventory, InventoryPlayer playerInventory, int xInv, int yInv) {
		this.inventory = inventory;

		addPlayerInventory(playerInventory, xInv, yInv);
	}

	@Override
	protected void addHotbarSlot(InventoryPlayer playerInventory, int slot, int x, int y) {
		ItemStack stackInSlot = playerInventory.func_70301_a(slot);

		if (inventory.isParentItemInventory(stackInSlot)) {
			func_75146_a(new SlotLocked(playerInventory, slot, x, y));
		} else {
			func_75146_a(new Slot(playerInventory, slot, x, y));
		}
	}

	@Override
	protected final boolean canAccess(EntityPlayer player) {
		return func_75145_c(player);
	}

	@Override
	public final boolean func_75145_c(EntityPlayer entityplayer) {
		return inventory.func_70300_a(entityplayer);
	}

	@Override
	public ItemStack func_184996_a(int slotId, int dragType_or_button, ClickType clickTypeIn, EntityPlayer player) {
		ItemStack result = super.func_184996_a(slotId, dragType_or_button, clickTypeIn, player);
		if(slotId > 0){
			inventory.onSlotClick(field_75151_b.get(slotId).getSlotIndex(), player);
		}
		return result;
	}
	
	public I getItemInventory() {
		return inventory;
	}

}
