/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.fluids;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class DrainOnlyFluidHandlerWrapper
implements IFluidHandler {
    @Nonnull
    private final IFluidHandler internalFluidHandler;

    public DrainOnlyFluidHandlerWrapper(@Nonnull IFluidHandler internalFluidHandler) {
        this.internalFluidHandler = internalFluidHandler;
    }

    public IFluidTankProperties[] getTankProperties() {
        IFluidTankProperties[] internalTankProperties = this.internalFluidHandler.getTankProperties();
        IFluidTankProperties[] tankProperties = new IFluidTankProperties[internalTankProperties.length];
        for (int i = 0; i < internalTankProperties.length; ++i) {
            IFluidTankProperties fluidTankProperties = internalTankProperties[i];
            tankProperties[i] = new DrainOnlyFluidPropertiesWrapper(fluidTankProperties);
        }
        return tankProperties;
    }

    public int fill(FluidStack resource, boolean doFill) {
        return 0;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return this.internalFluidHandler.drain(resource, doDrain);
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.internalFluidHandler.drain(maxDrain, doDrain);
    }

    private static class DrainOnlyFluidPropertiesWrapper
    implements IFluidTankProperties {
        @Nonnull
        private final IFluidTankProperties internalTankProperties;

        public DrainOnlyFluidPropertiesWrapper(@Nonnull IFluidTankProperties internalTankProperties) {
            this.internalTankProperties = internalTankProperties;
        }

        @Nullable
        public FluidStack getContents() {
            return this.internalTankProperties.getContents();
        }

        public int getCapacity() {
            return this.internalTankProperties.getCapacity();
        }

        public boolean canFill() {
            return false;
        }

        public boolean canDrain() {
            return this.internalTankProperties.canDrain();
        }

        public boolean canFillFluidType(FluidStack fluidStack) {
            return false;
        }

        public boolean canDrainFluidType(FluidStack fluidStack) {
            return this.internalTankProperties.canDrainFluidType(fluidStack);
        }
    }
}

