/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network.packets;

import forestry.api.core.ICamouflageHandler;
import forestry.api.multiblock.IMultiblockComponent;
import forestry.api.multiblock.IMultiblockController;
import forestry.core.gui.ContainerCamouflageSprayCan;
import forestry.core.inventory.ItemInventoryCamouflageSprayCan;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IForestryPacketServer;
import forestry.core.network.PacketIdServer;
import forestry.core.network.packets.CamouflageSelectionType;
import forestry.core.network.packets.PacketCamouflageSelectClient;
import forestry.core.network.packets.PacketCoordinates;
import forestry.core.proxy.Proxies;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class PacketCamouflageSelectServer
extends PacketCoordinates
implements IForestryPacketServer {
    private ItemStack camouflageStack;
    private String camouflageType;
    private CamouflageSelectionType selectionType;

    public PacketCamouflageSelectServer() {
    }

    public PacketCamouflageSelectServer(ICamouflageHandler handler, String camouflageType, CamouflageSelectionType selectionType) {
        super(handler.getCoordinates());
        this.camouflageStack = handler.getCamouflageBlock(camouflageType);
        this.selectionType = selectionType;
        this.camouflageType = camouflageType;
    }

    @Override
    public PacketIdServer getPacketId() {
        return PacketIdServer.CAMOUFLAGE_SELECTION;
    }

    @Override
    protected void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        data.writeShort(this.selectionType.ordinal());
        data.writeBoolean(this.camouflageType != null);
        if (this.camouflageType != null) {
            data.writeUTF(this.camouflageType);
        }
        data.writeItemStack(this.camouflageStack);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.selectionType = CamouflageSelectionType.values()[data.readShort()];
        if (data.readBoolean()) {
            this.camouflageType = data.readUTF();
        }
        this.camouflageStack = data.readItemStack();
    }

    @Override
    public void onPacketData(DataInputStreamForestry data, EntityPlayerMP player) {
        ContainerCamouflageSprayCan container;
        ItemInventoryCamouflageSprayCan itemInventoryCamouflageSprayCan;
        TileEntity tile = this.getTarget(player.field_70170_p);
        ICamouflageHandler handler = null;
        if (this.selectionType == CamouflageSelectionType.MULTIBLOCK) {
            IMultiblockController controller;
            if (tile instanceof IMultiblockComponent && (controller = ((IMultiblockComponent)tile).getMultiblockLogic().getController()) instanceof ICamouflageHandler) {
                handler = (ICamouflageHandler)((Object)controller);
            }
        } else if (this.selectionType == CamouflageSelectionType.TILE) {
            if (tile instanceof ICamouflageHandler) {
                handler = (ICamouflageHandler)tile;
            }
        } else if (player.field_71070_bA instanceof ContainerCamouflageSprayCan && (itemInventoryCamouflageSprayCan = (ItemInventoryCamouflageSprayCan)(container = (ContainerCamouflageSprayCan)player.field_71070_bA).getItemInventory()) != null) {
            handler = itemInventoryCamouflageSprayCan;
        }
        if (handler != null) {
            handler.setCamouflageBlock(this.camouflageType, this.camouflageStack);
            if (this.selectionType != CamouflageSelectionType.ITEM) {
                Proxies.net.sendNetworkPacket(new PacketCamouflageSelectClient(handler, this.camouflageType, this.selectionType), player.field_70170_p);
            }
        }
    }
}

