/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes.jei.carpenter;

import forestry.api.recipes.ICarpenterRecipe;
import forestry.api.recipes.IDescriptiveRecipe;
import forestry.core.recipes.jei.ForestryRecipeCategory;
import forestry.core.render.ForestryResource;
import forestry.factory.recipes.jei.FactoryJeiPlugin;
import forestry.factory.recipes.jei.carpenter.CarpenterRecipeWrapper;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.ICraftingGridHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IStackHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class CarpenterRecipeCategory
extends ForestryRecipeCategory<CarpenterRecipeWrapper> {
    private static final int boxSlot = 0;
    private static final int craftOutputSlot = 1;
    private static final int craftInputSlot = 2;
    private static final int inputTank = 0;
    private static final ResourceLocation guiTexture = new ForestryResource("textures/gui/carpenter.png");
    @Nonnull
    private final ICraftingGridHelper craftingGridHelper;
    @Nonnull
    private final IDrawableAnimated arrow;
    @Nonnull
    private final IDrawable tankOverlay;

    public CarpenterRecipeCategory(IGuiHelper guiHelper) {
        super((IDrawable)guiHelper.createDrawable(guiTexture, 9, 16, 158, 61), "tile.for.carpenter.name");
        this.craftingGridHelper = guiHelper.createCraftingGridHelper(2, 1);
        IDrawableStatic arrowDrawable = guiHelper.createDrawable(guiTexture, 176, 59, 4, 17);
        this.arrow = guiHelper.createAnimatedDrawable(arrowDrawable, 200, IDrawableAnimated.StartDirection.BOTTOM, false);
        this.tankOverlay = guiHelper.createDrawable(guiTexture, 176, 0, 16, 58);
    }

    @Nonnull
    public String getUid() {
        return "forestry.carpenter";
    }

    public void drawAnimations(@Nonnull Minecraft minecraft) {
        this.arrow.draw(minecraft, 89, 34);
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull CarpenterRecipeWrapper recipeWrapper, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        IGuiFluidStackGroup guiFluidStacks = recipeLayout.getFluidStacks();
        guiItemStacks.init(0, true, 73, 3);
        guiItemStacks.init(1, false, 70, 34);
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                int index = 2 + x + y * 3;
                guiItemStacks.init(index, true, x * 18, 3 + y * 18);
            }
        }
        guiFluidStacks.init(0, true, 141, 1, 16, 58, 10000, false, this.tankOverlay);
        ICarpenterRecipe recipe = (ICarpenterRecipe)recipeWrapper.getRecipe();
        ItemStack box = recipe.getBox();
        if (box != null) {
            guiItemStacks.set(0, box);
        }
        List outputs = ingredients.getOutputs(ItemStack.class);
        this.craftingGridHelper.setOutput(guiItemStacks, outputs);
        IDescriptiveRecipe craftingGridRecipe = recipe.getCraftingGridRecipe();
        List<Object> inputs = Arrays.asList(craftingGridRecipe.getIngredients());
        IStackHelper stackHelper = FactoryJeiPlugin.jeiHelpers.getStackHelper();
        List craftInputs = stackHelper.expandRecipeItemStackInputs(inputs);
        this.craftingGridHelper.setInputStacks(guiItemStacks, craftInputs, craftingGridRecipe.getWidth(), craftingGridRecipe.getHeight());
        List fluidInputs = ingredients.getInputs(FluidStack.class);
        if (!fluidInputs.isEmpty()) {
            guiFluidStacks.set(0, (List)fluidInputs.get(0));
        }
    }
}

