/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks.slab;

import forestry.api.arboriculture.EnumForestryWoodType;
import forestry.api.core.IItemModelRegister;
import forestry.api.core.IStateMapperRegister;
import forestry.arboriculture.IWoodTyped;
import forestry.arboriculture.blocks.property.PropertyForestryWoodType;
import forestry.arboriculture.blocks.slab.BlockForestrySlab;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public abstract class BlockArbSlab
extends BlockForestrySlab<EnumForestryWoodType>
implements IWoodTyped,
IItemModelRegister,
IStateMapperRegister {
    public static List<BlockArbSlab> create(boolean fireproof, final boolean doubleSlab) {
        ArrayList<BlockArbSlab> blocks = new ArrayList<BlockArbSlab>();
        PropertyForestryWoodType[] variants = PropertyForestryWoodType.create("variant", 8);
        for (int i = 0; i < variants.length; ++i) {
            final PropertyForestryWoodType variant = variants[i];
            BlockArbSlab block = new BlockArbSlab(fireproof, i){

                @Nonnull
                public PropertyForestryWoodType getVariant() {
                    return variant;
                }

                public boolean func_176552_j() {
                    return doubleSlab;
                }
            };
            blocks.add(block);
        }
        return blocks;
    }

    private BlockArbSlab(boolean fireproof, int blockNumber) {
        super(fireproof, blockNumber);
    }

    @Override
    @Nonnull
    public EnumForestryWoodType getWoodType(int meta) {
        int variantCount = this.getVariant().func_177700_c().size();
        int variantMeta = meta % variantCount + this.getBlockNumber() * 8;
        return EnumForestryWoodType.byMetadata(variantMeta);
    }
}

