/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.core.models;

import javax.annotation.Nonnull;
import java.util.Collections;
import java.util.List;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

import net.minecraftforge.common.property.IExtendedBlockState;

import forestry.api.core.IModelBaker;
import forestry.api.core.IModelBakerModel;
import forestry.core.blocks.propertys.UnlistedBlockAccess;
import forestry.core.blocks.propertys.UnlistedBlockPos;
import forestry.core.models.baker.ModelBaker;

public abstract class ModelBlockDefault<B extends Block, K extends Object> implements IBakedModel {
	private ItemOverrideList overrideList;
	@Nonnull
	protected final Class<B> blockClass;
	
	protected IModelBakerModel blockModel;
	protected IModelBakerModel itemModel;

	protected ModelBlockDefault(@Nonnull Class<B> blockClass) {
		this.blockClass = blockClass;
	}

	protected IBakedModel bakeModel(IBlockState state, K key) {
		if (key == null) {
			return null;
		}

		if(state instanceof IExtendedBlockState) {
			IModelBaker baker = new ModelBaker();
			IExtendedBlockState stateExtended = (IExtendedBlockState) state;

			IBlockAccess world = stateExtended.getValue(UnlistedBlockAccess.BLOCKACCESS);
			BlockPos pos = stateExtended.getValue(UnlistedBlockPos.POS);
			Block block = state.func_177230_c();
			if (!blockClass.isInstance(block)) {
				return null;
			}
			B bBlock = blockClass.cast(block);

			baker.setRenderBounds(state.func_185900_c(world, pos));
			bakeBlock(bBlock, key, baker, false);

			blockModel = baker.bakeModel(false);
			onCreateModel(blockModel);
			return blockModel;
		} else {
			return null;
		}
	}

	protected IBakedModel getModel(IBlockState state, IBlockAccess world, BlockPos pos) {
		return bakeModel(state, getWorldKey(state, world, pos));
	}

	protected IBakedModel bakeModel(ItemStack stack, World world, K key) {
		if (key == null) {
			return null;
		}

		IModelBaker baker = new ModelBaker();
		Block block = Block.func_149634_a(stack.func_77973_b());
		if (!blockClass.isInstance(block)) {
			return null;
		}
		B bBlock = blockClass.cast(block);

		// FIXME: This way of getting the IBlockState will probably backfire.
		IBlockState state = block.func_176203_a(stack.func_77952_i());
		baker.setRenderBounds(state.func_185900_c(world, null));
		bakeBlock(bBlock, key, baker, true);

		return itemModel = baker.bakeModel(true);
	}

	protected IBakedModel getModel(ItemStack stack, World world) {
		return bakeModel(stack, world, getInventoryKey(stack));
	}

	@Override
	public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
		IBakedModel model;

		if (state instanceof IExtendedBlockState) {
			IExtendedBlockState stateExtended = (IExtendedBlockState) state;
			IBlockAccess world = stateExtended.getValue(UnlistedBlockAccess.BLOCKACCESS);
			BlockPos pos = stateExtended.getValue(UnlistedBlockPos.POS);
			model = getModel(state, world, pos);
		} else {
			model = getModel(state, null, null);
		}

		if (model != null) {
			return model.func_188616_a(state, side, rand);
		} else {
			return Collections.emptyList();
		}
	}
	
	protected void onCreateModel(IModelBakerModel model){
		model.setAmbientOcclusion(true);
	}

	@Override
	public boolean func_177555_b() {
		if(itemModel == null && blockModel == null) {
			return false;
		}
		return blockModel != null ? blockModel.func_177555_b() : itemModel.func_177555_b();
	}

	@Override
	public boolean func_177556_c() {
		if(itemModel == null) {
			return false;
		}
		return itemModel.func_177556_c();
	}

	@Override
	public boolean func_188618_c() {
		if(itemModel == null && blockModel == null) {
			return false;
		}
		return blockModel != null ? blockModel.func_188618_c() : itemModel.func_188618_c();
	}
	
	@Override
	public TextureAtlasSprite func_177554_e() {
		if(blockModel != null) {
			return blockModel.func_177554_e();
		}
		return null;
	}

	@Override
	public ItemCameraTransforms func_177552_f() {
		if(itemModel == null) {
			return null;
		}
		return itemModel.func_177552_f();
	}

	protected ItemOverrideList createOverrides() {
		return new DefaultItemOverrideList();
	}

	@Override
	public ItemOverrideList func_188617_f() {
		if (overrideList == null) {
			overrideList = createOverrides();
		}
		return overrideList;
	}

	protected abstract K getInventoryKey(@Nonnull ItemStack stack);
	protected abstract K getWorldKey(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos);
	protected abstract void bakeBlock(@Nonnull B block, @Nonnull K key, @Nonnull IModelBaker baker, boolean inventory);

	private class DefaultItemOverrideList extends ItemOverrideList {
		public DefaultItemOverrideList() {
			super(Collections.emptyList());
		}
		
		@Override
		public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
			return getModel(stack, world);
		}
	}
}
