/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.models;

import forestry.api.core.CamouflageManager;
import forestry.api.core.ICamouflageHandler;
import forestry.api.core.ICamouflageItemHandler;
import forestry.api.core.ICamouflagedTile;
import forestry.api.core.IModelBaker;
import forestry.core.models.ModelBlockDefault;
import forestry.core.utils.CamouflageUtil;
import forestry.greenhouse.blocks.BlockGreenhouse;
import forestry.greenhouse.blocks.BlockGreenhouseType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.property.IExtendedBlockState;
import org.apache.commons.lang3.tuple.Pair;

public class ModelGreenhouse
extends ModelBlockDefault<BlockGreenhouse> {
    public ModelGreenhouse() {
        super(BlockGreenhouse.class);
    }

    @Override
    protected void bakeInventoryBlock(@Nonnull BlockGreenhouse block, @Nonnull ItemStack item, @Nonnull IModelBaker baker) {
        ModelGreenhouse.bakeBlockModel(block, null, null, null, baker, null);
    }

    @Override
    protected void bakeWorldBlock(@Nonnull BlockGreenhouse block, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IExtendedBlockState stateExtended, @Nonnull IModelBaker baker) {
        ItemStack camouflageStack = CamouflageUtil.getCamouflageBlock(world, pos);
        ModelGreenhouse.bakeBlockModel(block, world, pos, stateExtended, baker, camouflageStack);
    }

    private static void bakeBlockModel(@Nonnull BlockGreenhouse block, @Nullable IBlockAccess world, @Nullable BlockPos pos, @Nullable IExtendedBlockState stateExtended, @Nonnull IModelBaker baker, @Nullable ItemStack camouflageStack) {
        if (camouflageStack != null) {
            ICamouflageHandler camouflageHandler = CamouflageUtil.getCamouflageHandler(world, pos);
            ICamouflagedTile camouflageTile = (ICamouflagedTile)world.func_175625_s(pos);
            ICamouflageItemHandler itemHandler = CamouflageManager.camouflageAccess.getHandlerFromItem(camouflageStack);
            if (itemHandler != null) {
                Pair<IBlockState, IBakedModel> model = itemHandler.getModel(camouflageStack, camouflageHandler, camouflageTile);
                baker.addBakedModel((IBlockState)model.getLeft(), (IBakedModel)model.getRight());
                baker.setParticleSprite(((IBakedModel)model.getRight()).func_177554_e());
            }
        } else if (block.getGreenhouseType() == BlockGreenhouseType.GLASS) {
            TextureAtlasSprite glassSprite = BlockGreenhouseType.getSprite(BlockGreenhouseType.GLASS, null, null, world, pos);
            baker.addBlockModel((Block)block, Block.field_185505_j, pos, BlockGreenhouseType.getSprite(BlockGreenhouseType.GLASS, null, null, world, pos), 100);
            baker.setParticleSprite(glassSprite);
        } else {
            TextureAtlasSprite plainSprite = BlockGreenhouseType.getSprite(BlockGreenhouseType.PLAIN, null, null, world, pos);
            baker.addBlockModel((Block)block, Block.field_185505_j, pos, BlockGreenhouseType.getSprite(BlockGreenhouseType.PLAIN, null, null, world, pos), 100);
            baker.setParticleSprite(plainSprite);
        }
        if (block.getGreenhouseType().hasOverlaySprite) {
            TextureAtlasSprite[] sprite = new TextureAtlasSprite[6];
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                sprite[facing.ordinal()] = BlockGreenhouseType.getSprite(block.getGreenhouseType(), facing, (IBlockState)stateExtended, world, pos);
            }
            baker.addBlockModel((Block)block, Block.field_185505_j, pos, sprite, 101);
        }
    }
}

