/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.TreeBlockTypeLeaf;
import forestry.arboriculture.worldgen.TreeBlockTypeLog;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.worldgen.WorldGenHelper;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WorldGenPadauk
extends WorldGenTree {
    public WorldGenPadauk(ITreeGenData tree) {
        super(tree, 6, 6);
    }

    @Override
    @Nonnull
    public Set<BlockPos> generateTrunk(World world, Random rand, TreeBlockTypeLog wood, BlockPos startPos) {
        WorldGenHelper.generateTreeTrunk(world, rand, wood, startPos, this.height, this.girth, 0, 0.0f, null, 0.0f);
        int branchSpawn = this.height - 2;
        int count = 0;
        int max = 3;
        int min = 1;
        int canopyHeight = rand.nextInt(max - min + 1) + min;
        while (branchSpawn > 3 && count < canopyHeight) {
            ++count;
            for (int i = 0; i < this.girth * 4; ++i) {
                if (!rand.nextBoolean()) continue;
                int[] offset = new int[]{-1, 1};
                int offsetValue = offset[new Random().nextInt(offset.length)];
                int maxBranchLength = 3;
                int branchLength = new Random().nextInt(maxBranchLength + 1);
                EnumFacing[] direction = new EnumFacing[]{EnumFacing.NORTH, EnumFacing.EAST};
                EnumFacing directionValue = direction[new Random().nextInt(direction.length)];
                int branchSpawnY = branchSpawn;
                for (int j = 1; j < branchLength + 1; ++j) {
                    if (j == branchLength && rand.nextBoolean()) {
                        ++branchSpawnY;
                    }
                    wood.setDirection(directionValue);
                    if (directionValue == EnumFacing.NORTH) {
                        WorldGenHelper.addBlock(world, startPos.func_177982_a(0, branchSpawnY, j * offsetValue), wood, WorldGenHelper.EnumReplaceMode.ALL);
                        continue;
                    }
                    if (directionValue != EnumFacing.EAST) continue;
                    WorldGenHelper.addBlock(world, startPos.func_177982_a(j * offsetValue, branchSpawnY, 0), wood, WorldGenHelper.EnumReplaceMode.ALL);
                }
            }
        }
        return Collections.emptySet();
    }

    @Override
    protected void generateLeaves(World world, Random rand, TreeBlockTypeLeaf leaf, List<BlockPos> branchEnds, BlockPos startPos) {
        int leafSpawn = this.height + 1;
        WorldGenHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, this.girth, 1, WorldGenHelper.EnumReplaceMode.SOFT);
        WorldGenHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, 1.5f + (float)this.girth, 1, WorldGenHelper.EnumReplaceMode.SOFT);
        WorldGenHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, 3.0f + (float)this.girth, 1, WorldGenHelper.EnumReplaceMode.SOFT);
        int max = 3;
        int min = 1;
        int canopyHeight = rand.nextInt(max - min + 1) + min;
        for (int count = 0; leafSpawn > 3 && count < canopyHeight; ++count) {
            int yCenter = leafSpawn--;
            WorldGenHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, yCenter, 0), this.girth, 4.5f + (float)this.girth, 1, WorldGenHelper.EnumReplaceMode.SOFT);
        }
    }
}

