/*
 * Decompiled with CFR 0.152.
 */
package forestry.core;

import forestry.api.core.ICamouflageAccess;
import forestry.api.core.ICamouflageItemHandler;
import forestry.core.utils.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;

public class CamouflageAccess
implements ICamouflageAccess {
    private static final Map<String, List<ICamouflageItemHandler>> camouflageItemHandlers = new HashMap<String, List<ICamouflageItemHandler>>();
    private static final Map<String, List<ItemStack>> camouflageItemBlacklist = new HashMap<String, List<ItemStack>>();

    @Override
    public void registerCamouflageItemHandler(@Nonnull ICamouflageItemHandler itemHandler) {
        if (itemHandler == null) {
            Log.error("Fail to register a camouflage item handler, because the handler is null. The handler is form the mod with the ID: " + Loader.instance().activeModContainer().getModId() + ".", new Object[0]);
            return;
        }
        String type = itemHandler.getType();
        if (!camouflageItemHandlers.containsKey(type)) {
            camouflageItemHandlers.put(type, new ArrayList());
        }
        if (!camouflageItemHandlers.containsValue(itemHandler)) {
            camouflageItemHandlers.get(type).add(itemHandler);
        } else {
            Log.error("Fail to register a camouflage item handler, because the handler is already registered. The handler is form the mod with the ID: " + Loader.instance().activeModContainer().getModId() + ".", new Object[0]);
        }
    }

    @Override
    public List<ICamouflageItemHandler> getCamouflageItemHandler(String type) {
        if (type == null) {
            ArrayList<ICamouflageItemHandler> handlers = new ArrayList<ICamouflageItemHandler>();
            for (List<ICamouflageItemHandler> handler : camouflageItemHandlers.values()) {
                handlers.addAll(handler);
            }
            return handlers;
        }
        if (!camouflageItemHandlers.containsKey(type)) {
            return null;
        }
        return camouflageItemHandlers.get(type);
    }

    @Override
    public void addItemToBlackList(String type, ItemStack camouflageBlock) {
        if (camouflageBlock == null || camouflageBlock.func_77973_b() == null) {
            Log.error("Fail to add camouflage block item to the black list, because it is null", new Object[0]);
            return;
        }
        Block block = Block.func_149634_a((Item)camouflageBlock.func_77973_b());
        if (block == null) {
            Log.error("Fail to add camouflage block item to the black list: because it has no block.", new Object[0]);
            return;
        }
        for (ItemStack camouflageBlacklisted : camouflageItemBlacklist.get(type)) {
            if (camouflageBlacklisted.func_77973_b() != camouflageBlock.func_77973_b() || camouflageBlacklisted.func_77952_i() != camouflageBlock.func_77952_i() || !ItemStack.func_77970_a((ItemStack)camouflageBlock, (ItemStack)camouflageBlacklisted)) continue;
            Log.error("Fail to add camouflage block item to the black list, because it is already registered: " + camouflageBlock + ".", new Object[0]);
            return;
        }
        camouflageItemBlacklist.get(type).add(camouflageBlock);
    }

    @Override
    public boolean isItemBlackListed(String type, ItemStack camouflageBlock) {
        List<Object> camouflageItemBlacklisted;
        if (camouflageBlock == null || camouflageBlock.func_77973_b() == null || Block.func_149634_a((Item)camouflageBlock.func_77973_b()) == null || type != null && !camouflageItemBlacklist.containsKey(type)) {
            return false;
        }
        if (type == null) {
            camouflageItemBlacklisted = new ArrayList();
            for (List list : camouflageItemBlacklist.values()) {
                camouflageItemBlacklisted.addAll(list);
            }
        } else {
            camouflageItemBlacklisted = camouflageItemBlacklist.get(type);
        }
        for (ItemStack itemStack : camouflageItemBlacklisted) {
            if (itemStack.func_77973_b() != camouflageBlock.func_77973_b() || itemStack.func_77952_i() != camouflageBlock.func_77952_i() || !ItemStack.func_77970_a((ItemStack)camouflageBlock, (ItemStack)itemStack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ICamouflageItemHandler getHandlerFromItem(ItemStack stack) {
        for (List<ICamouflageItemHandler> handlers : camouflageItemHandlers.values()) {
            for (ICamouflageItemHandler handler : handlers) {
                if (!handler.canHandle(stack)) continue;
                return handler;
            }
        }
        return null;
    }
}

