/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.core.entities;

import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.Particle;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class ParticleColoredDripParticle extends Particle {

	/**
	 * The height of the current bob
	 */
	private int bobTimer;

	public ParticleColoredDripParticle(World world, double x, double y, double z, float red, float green, float blue) {
		super(world, x, y, z, 0.0D, 0.0D, 0.0D);
		this.field_187129_i = this.field_187130_j = this.field_187131_k = 0.0D;
		
		this.field_70552_h = red;
		this.field_70553_i = green;
		this.field_70551_j = blue;

		this.func_70536_a(113);
		this.func_187115_a(0.01F, 0.01F);
		this.field_70545_g = 0.06F;
		this.bobTimer = 40;
		this.field_70547_e = (int) (64.0D / (Math.random() * 0.8D + 0.2D));
		this.field_187129_i = this.field_187130_j = this.field_187131_k = 0.0D;
	}

	/**
	 * Called to update the entity's position/logic.
	 */
	@Override
	public void func_189213_a() {
		this.field_187123_c = this.field_187126_f;
		this.field_187124_d = this.field_187127_g;
		this.field_187125_e = this.field_187128_h;

		this.field_187130_j -= this.field_70545_g;

		if (this.bobTimer-- > 0) {
			this.field_187129_i *= 0.02D;
			this.field_187130_j *= 0.02D;
			this.field_187131_k *= 0.02D;
			this.func_70536_a(113);
		} else {
			this.func_70536_a(112);
		}

		this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
		this.field_187129_i *= 0.9800000190734863D;
		this.field_187130_j *= 0.9800000190734863D;
		this.field_187131_k *= 0.9800000190734863D;

		if (this.field_70547_e-- <= 0) {
			this.func_187112_i();
		}

		if (this.field_187132_l) {
			this.func_70536_a(114);

			this.field_187129_i *= 0.699999988079071D;
			this.field_187131_k *= 0.699999988079071D;
		}
		
		BlockPos blockpos = new BlockPos(this.field_187126_f, this.field_187127_g, this.field_187128_h);
		IBlockState iblockstate = this.field_187122_b.func_180495_p(blockpos);
		Material material = iblockstate.func_185904_a();
		
		if (material.func_76224_d() || material.func_76220_a()) {
			double d0 = 0.0D;
			
			if (iblockstate.func_177230_c() instanceof BlockLiquid) {
				d0 = BlockLiquid.func_149801_b(iblockstate.func_177229_b(BlockLiquid.field_176367_b));
			}
			
			double d1 = MathHelper.func_76128_c(this.field_187127_g) + 1 - d0;
			
			if (this.field_187127_g < d1) {
				this.func_187112_i();
			}
		}
	}
}
