/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.multiblock;

import com.mojang.authlib.GameProfile;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBeeHousingInventory;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.climate.IClimateControlled;
import forestry.api.core.BiomeHelper;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.ForestryAPI;
import forestry.api.multiblock.IAlvearyComponent;
import forestry.api.multiblock.IMultiblockComponent;
import forestry.apiculture.AlvearyBeeModifier;
import forestry.apiculture.InventoryBeeHousing;
import forestry.apiculture.multiblock.AlvearyMultiblockSizeLimits;
import forestry.apiculture.multiblock.IAlvearyControllerInternal;
import forestry.apiculture.multiblock.TileAlvearyPlain;
import forestry.core.inventory.FakeInventoryAdapter;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.multiblock.IMultiblockControllerInternal;
import forestry.core.multiblock.MultiblockValidationException;
import forestry.core.multiblock.RectangularMultiblockControllerBase;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.proxy.Proxies;
import forestry.core.utils.BlockUtil;
import forestry.core.utils.Translator;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class AlvearyController
extends RectangularMultiblockControllerBase
implements IAlvearyControllerInternal,
IClimateControlled {
    @Nonnull
    private final InventoryBeeHousing inventory;
    private final IBeekeepingLogic beekeepingLogic;
    private Biome cachedBiome;
    private float tempChange = 0.0f;
    private float humidChange = 0.0f;
    private final Set<IBeeModifier> beeModifiers = new HashSet<IBeeModifier>();
    private final Set<IBeeListener> beeListeners = new HashSet<IBeeListener>();
    private final Set<IAlvearyComponent.Climatiser> climatisers = new HashSet<IAlvearyComponent.Climatiser>();
    private final Set<IAlvearyComponent.Active> activeComponents = new HashSet<IAlvearyComponent.Active>();
    private int breedingProgressPercent = 0;

    public AlvearyController(World world) {
        super(world, AlvearyMultiblockSizeLimits.instance);
        this.inventory = new InventoryBeeHousing(9);
        this.beekeepingLogic = BeeManager.beeRoot.createBeekeepingLogic(this);
        this.beeModifiers.add(new AlvearyBeeModifier());
    }

    @Override
    @Nonnull
    public IBeeHousingInventory getBeeInventory() {
        return this.inventory;
    }

    @Override
    public IBeekeepingLogic getBeekeepingLogic() {
        return this.beekeepingLogic;
    }

    @Override
    @Nonnull
    public IInventoryAdapter getInternalInventory() {
        if (this.isAssembled()) {
            return this.inventory;
        }
        return FakeInventoryAdapter.instance();
    }

    @Override
    public Iterable<IBeeListener> getBeeListeners() {
        return this.beeListeners;
    }

    @Override
    public Iterable<IBeeModifier> getBeeModifiers() {
        return this.beeModifiers;
    }

    @Override
    public void onAttachedPartWithMultiblockData(IMultiblockComponent part, NBTTagCompound data) {
        this.readFromNBT(data);
    }

    @Override
    protected void onBlockAdded(IMultiblockComponent newPart) {
        if (newPart instanceof IAlvearyComponent) {
            if (newPart instanceof IAlvearyComponent.BeeModifier) {
                IAlvearyComponent.BeeModifier alvearyBeeModifier = (IAlvearyComponent.BeeModifier)newPart;
                IBeeModifier beeModifier = alvearyBeeModifier.getBeeModifier();
                this.beeModifiers.add(beeModifier);
            }
            if (newPart instanceof IAlvearyComponent.BeeListener) {
                IAlvearyComponent.BeeListener beeListenerSource = (IAlvearyComponent.BeeListener)newPart;
                IBeeListener beeListener = beeListenerSource.getBeeListener();
                this.beeListeners.add(beeListener);
            }
            if (newPart instanceof IAlvearyComponent.Climatiser) {
                this.climatisers.add((IAlvearyComponent.Climatiser)newPart);
            }
            if (newPart instanceof IAlvearyComponent.Active) {
                this.activeComponents.add((IAlvearyComponent.Active)newPart);
            }
        }
    }

    @Override
    protected void onBlockRemoved(IMultiblockComponent oldPart) {
        if (oldPart instanceof IAlvearyComponent) {
            if (oldPart instanceof IAlvearyComponent.BeeModifier) {
                IAlvearyComponent.BeeModifier alvearyBeeModifier = (IAlvearyComponent.BeeModifier)oldPart;
                IBeeModifier beeModifier = alvearyBeeModifier.getBeeModifier();
                this.beeModifiers.remove(beeModifier);
            }
            if (oldPart instanceof IAlvearyComponent.BeeListener) {
                IAlvearyComponent.BeeListener beeListenerSource = (IAlvearyComponent.BeeListener)oldPart;
                IBeeListener beeListener = beeListenerSource.getBeeListener();
                this.beeListeners.remove(beeListener);
            }
            if (oldPart instanceof IAlvearyComponent.Climatiser) {
                this.climatisers.remove(oldPart);
            }
            if (oldPart instanceof IAlvearyComponent.Active) {
                this.activeComponents.remove(oldPart);
            }
        }
    }

    @Override
    protected void isMachineWhole() throws MultiblockValidationException {
        Block block;
        super.isMachineWhole();
        BlockPos maximumCoord = this.getMaximumCoord();
        BlockPos minimumCoord = this.getMinimumCoord();
        int slabY = maximumCoord.func_177956_o() + 1;
        for (int slabX = minimumCoord.func_177958_n(); slabX <= maximumCoord.func_177958_n(); ++slabX) {
            for (int slabZ = minimumCoord.func_177952_p(); slabZ <= maximumCoord.func_177952_p(); ++slabZ) {
                BlockPos pos = new BlockPos(slabX, slabY, slabZ);
                IBlockState state = this.worldObj.func_180495_p(pos);
                if (!BlockUtil.isWoodSlabBlock(state, block = state.func_177230_c(), (IBlockAccess)this.worldObj, pos)) {
                    throw new MultiblockValidationException(Translator.translateToLocal("for.multiblock.alveary.error.needSlabs"));
                }
                int meta = block.func_176201_c(state);
                if ((meta & 8) == 0) continue;
                throw new MultiblockValidationException(Translator.translateToLocal("for.multiblock.alveary.error.needSlabs"));
            }
        }
        int airY = maximumCoord.func_177956_o();
        for (int airX = minimumCoord.func_177958_n() - 1; airX <= maximumCoord.func_177958_n() + 1; ++airX) {
            for (int airZ = minimumCoord.func_177952_p() - 1; airZ <= maximumCoord.func_177952_p() + 1; ++airZ) {
                IBlockState blockState;
                if (this.isCoordInMultiblock(airX, airY, airZ) || !(block = (blockState = this.worldObj.func_180495_p(new BlockPos(airX, airY, airZ))).func_177230_c()).func_149662_c(blockState)) continue;
                throw new MultiblockValidationException(Translator.translateToLocal("for.multiblock.alveary.error.needSpace"));
            }
        }
    }

    @Override
    protected void isGoodForExteriorLevel(IMultiblockComponent part, int level) throws MultiblockValidationException {
        if (level == 2 && !(part instanceof TileAlvearyPlain)) {
            throw new MultiblockValidationException(Translator.translateToLocal("for.multiblock.alveary.error.needPlainOnTop"));
        }
    }

    @Override
    protected void isGoodForInterior(IMultiblockComponent part) throws MultiblockValidationException {
        if (!(part instanceof TileAlvearyPlain)) {
            throw new MultiblockValidationException(Translator.translateToLocal("for.multiblock.alveary.error.needPlainInterior"));
        }
    }

    @Override
    protected void onAssimilate(IMultiblockControllerInternal assimilated) {
    }

    @Override
    public void onAssimilated(IMultiblockControllerInternal assimilator) {
    }

    @Override
    protected boolean updateServer(int tickCount) {
        for (IAlvearyComponent.Active activeComponent : this.activeComponents) {
            activeComponent.updateServer(tickCount);
        }
        boolean canWork = this.beekeepingLogic.canWork();
        if (canWork) {
            this.beekeepingLogic.doWork();
        }
        for (IAlvearyComponent.Climatiser climatiser : this.climatisers) {
            climatiser.changeClimate(tickCount, this);
        }
        this.tempChange = AlvearyController.equalizeChange(this.tempChange);
        this.humidChange = AlvearyController.equalizeChange(this.humidChange);
        return canWork;
    }

    private static float equalizeChange(float change) {
        if (change == 0.0f) {
            return 0.0f;
        }
        if ((change *= 0.95f) <= 0.001f && change >= -0.001f) {
            change = 0.0f;
        }
        return change;
    }

    @Override
    protected void updateClient(int tickCount) {
        for (IAlvearyComponent.Active activeComponent : this.activeComponents) {
            activeComponent.updateClient(tickCount);
        }
        if (this.beekeepingLogic.canDoBeeFX() && this.updateOnInterval(2)) {
            this.beekeepingLogic.doBeeFX();
            if (this.updateOnInterval(50)) {
                BlockPos center = this.getCenterCoord();
                float fxX = (float)center.func_177958_n() + 0.5f;
                float fxY = (float)center.func_177956_o() + 1.0f;
                float fxZ = (float)center.func_177952_p() + 0.5f;
                float distanceFromCenter = 1.6f;
                float leftRightSpreadFromCenter = distanceFromCenter * (this.worldObj.field_73012_v.nextFloat() - 0.5f);
                float upSpread = this.worldObj.field_73012_v.nextFloat() * 0.8f;
                Proxies.render.addEntityHoneyDustFX(this.worldObj, fxX - distanceFromCenter, fxY += upSpread, fxZ + leftRightSpreadFromCenter);
                Proxies.render.addEntityHoneyDustFX(this.worldObj, fxX + distanceFromCenter, fxY, fxZ + leftRightSpreadFromCenter);
                Proxies.render.addEntityHoneyDustFX(this.worldObj, fxX + leftRightSpreadFromCenter, fxY, fxZ - distanceFromCenter);
                Proxies.render.addEntityHoneyDustFX(this.worldObj, fxX + leftRightSpreadFromCenter, fxY, fxZ + distanceFromCenter);
            }
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        data = super.writeToNBT(data);
        data.func_74776_a("TempChange", this.tempChange);
        data.func_74776_a("HumidChange", this.humidChange);
        this.beekeepingLogic.writeToNBT(data);
        this.inventory.writeToNBT(data);
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.tempChange = data.func_74760_g("TempChange");
        this.humidChange = data.func_74760_g("HumidChange");
        this.beekeepingLogic.readFromNBT(data);
        this.inventory.readFromNBT(data);
    }

    @Override
    public void formatDescriptionPacket(NBTTagCompound data) {
        this.writeToNBT(data);
        this.beekeepingLogic.writeToNBT(data);
    }

    @Override
    public void decodeDescriptionPacket(NBTTagCompound data) {
        this.readFromNBT(data);
        this.beekeepingLogic.readFromNBT(data);
    }

    @Override
    public BlockPos getCoordinates() {
        BlockPos coord = this.getCenterCoord();
        return coord.func_177982_a(0, 1, 0);
    }

    @Override
    public Vec3d getBeeFXCoordinates() {
        BlockPos coord = this.getCenterCoord();
        return new Vec3d((double)coord.func_177958_n() + 0.5, (double)coord.func_177956_o() + 1.5, (double)coord.func_177952_p() + 0.5);
    }

    @Override
    public float getExactTemperature() {
        BlockPos coords = this.getReferenceCoord();
        return ForestryAPI.climateManager.getTemperature(this.getWorldObj(), coords) + this.tempChange;
    }

    @Override
    public float getExactHumidity() {
        BlockPos coords = this.getReferenceCoord();
        return ForestryAPI.climateManager.getHumidity(this.getWorldObj(), coords) + this.humidChange;
    }

    @Override
    public EnumTemperature getTemperature() {
        IBeeModifier beeModifier = BeeManager.beeRoot.createBeeHousingModifier(this);
        Biome biome = this.getBiome();
        if ((beeModifier.isHellish() || BiomeHelper.isBiomeHellish(biome)) && this.tempChange >= 0.0f) {
            return EnumTemperature.HELLISH;
        }
        return EnumTemperature.getFromValue(this.getExactTemperature());
    }

    @Override
    public EnumHumidity getHumidity() {
        return EnumHumidity.getFromValue(this.getExactHumidity());
    }

    @Override
    public GameProfile getOwner() {
        return this.getOwnerHandler().getOwner();
    }

    @Override
    public String getUnlocalizedType() {
        return "for.multiblock.alveary.type";
    }

    @Override
    public Biome getBiome() {
        if (this.cachedBiome == null) {
            BlockPos coords = this.getReferenceCoord();
            this.cachedBiome = this.worldObj.func_180494_b(coords);
        }
        return this.cachedBiome;
    }

    @Override
    public int getBlockLightValue() {
        BlockPos topCenter = this.getTopCenterCoord();
        return this.worldObj.func_175671_l(topCenter.func_177984_a());
    }

    @Override
    public boolean canBlockSeeTheSky() {
        BlockPos topCenter = this.getTopCenterCoord();
        return this.worldObj.func_175710_j(topCenter.func_177982_a(0, 2, 0));
    }

    @Override
    public void addTemperatureChange(float change, float boundaryDown, float boundaryUp) {
        float temperature = ForestryAPI.climateManager.getTemperature(this.worldObj, this.getReferenceCoord());
        this.tempChange += change;
        this.tempChange = Math.max(boundaryDown - temperature, this.tempChange);
        this.tempChange = Math.min(boundaryUp - temperature, this.tempChange);
    }

    @Override
    public void addHumidityChange(float change, float boundaryDown, float boundaryUp) {
        float humidity = ForestryAPI.climateManager.getHumidity(this.worldObj, this.getReferenceCoord());
        this.humidChange += change;
        this.humidChange = Math.max(boundaryDown - humidity, this.humidChange);
        this.humidChange = Math.min(boundaryUp - humidity, this.humidChange);
    }

    @Override
    public int getHealthScaled(int i) {
        return this.breedingProgressPercent * i / 100;
    }

    @Override
    public void writeGuiData(DataOutputStreamForestry data) throws IOException {
        data.writeVarInt(this.beekeepingLogic.getBeeProgressPercent());
        data.writeVarInt(Math.round(this.tempChange * 100.0f));
        data.writeVarInt(Math.round(this.humidChange * 100.0f));
    }

    @Override
    public void readGuiData(DataInputStreamForestry data) throws IOException {
        this.breedingProgressPercent = data.readVarInt();
        this.tempChange = (float)data.readVarInt() / 100.0f;
        this.humidChange = (float)data.readVarInt() / 100.0f;
    }
}

