/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks.slab;

import forestry.api.arboriculture.IWoodType;
import forestry.api.arboriculture.TreeManager;
import forestry.api.arboriculture.WoodBlockKind;
import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.api.core.IStateMapperRegister;
import forestry.api.core.Tabs;
import forestry.arboriculture.IWoodTyped;
import forestry.arboriculture.WoodHelper;
import forestry.arboriculture.blocks.WoodTypeStateMapper;
import forestry.arboriculture.blocks.property.PropertyWoodType;
import forestry.core.proxy.Proxies;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockForestrySlab<T extends Enum<T>>
extends BlockSlab
implements IWoodTyped,
IItemModelRegister,
IStateMapperRegister {
    protected static final int VARIANTS_PER_BLOCK = 8;
    protected static final int VARIANTS_META_MASK = 7;
    private final boolean fireproof;
    private final int blockNumber;

    protected BlockForestrySlab(boolean fireproof, int blockNumber) {
        super(Material.field_151575_d);
        this.fireproof = fireproof;
        this.blockNumber = blockNumber;
        IBlockState iblockstate = this.field_176227_L.func_177621_b();
        if (!this.func_176552_j()) {
            iblockstate = iblockstate.func_177226_a((IProperty)field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM);
        }
        PropertyWoodType<T> variant = this.getVariant();
        this.func_180632_j(iblockstate.func_177226_a(variant, variant.getFirstType()));
        this.func_149647_a(Tabs.tabArboriculture);
        this.func_149713_g(0);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.setHarvestLevel("axe", 0);
    }

    @Override
    public boolean isFireproof() {
        return this.fireproof;
    }

    @Nonnull
    public abstract PropertyWoodType<T> getVariant();

    public int getBlockNumber() {
        return this.blockNumber;
    }

    protected BlockStateContainer func_180661_e() {
        return this.func_176552_j() ? new BlockStateContainer((Block)this, new IProperty[]{this.getVariant()}) : new BlockStateContainer((Block)this, new IProperty[]{field_176554_a, this.getVariant()});
    }

    public IBlockState func_176203_a(int meta) {
        T woodType = this.getWoodType(meta);
        IBlockState iblockstate = this.func_176223_P().func_177226_a(this.getVariant(), woodType);
        if (!this.func_176552_j()) {
            iblockstate = iblockstate.func_177226_a((IProperty)field_176554_a, (Comparable)((meta & 8) == 0 ? BlockSlab.EnumBlockHalf.BOTTOM : BlockSlab.EnumBlockHalf.TOP));
        }
        return iblockstate;
    }

    @Nonnull
    public abstract T getWoodType(int var1);

    public int func_176201_c(IBlockState state) {
        Enum woodType = (Enum)((Object)state.func_177229_b(this.getVariant()));
        int meta = ((IWoodType)((Object)woodType)).getMetadata() - this.blockNumber * 8;
        if (!this.func_176552_j() && state.func_177229_b((IProperty)field_176554_a) == BlockSlab.EnumBlockHalf.TOP) {
            meta |= 8;
        }
        return meta;
    }

    public int func_180651_a(IBlockState state) {
        return ((IWoodType)((Object)((Enum)((Object)state.func_177229_b(this.getVariant()))))).getMetadata() - this.blockNumber * 8;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        Enum woodType = (Enum)((Object)state.func_177229_b(this.getVariant()));
        ItemStack slab = TreeManager.woodAccess.getStack((IWoodType)((Object)woodType), this.getBlockKind(), this.isFireproof());
        return slab.func_77973_b();
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        Enum woodType = (Enum)((Object)state.func_177229_b(this.getVariant()));
        ItemStack slab = TreeManager.woodAccess.getStack((IWoodType)((Object)woodType), this.getBlockKind(), this.isFireproof());
        return new ItemStack(slab.func_77973_b(), 1, this.func_176201_c(state));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{WoodHelper.getDefaultResourceLocations(this)});
        manager.registerItemModel(item, new WoodHelper.WoodMeshDefinition(this));
    }

    public String func_150002_b(int meta) {
        T woodType = this.getWoodType(meta);
        return WoodHelper.getDisplayName(this, (IWoodType)woodType);
    }

    public void func_149666_a(Item item, CreativeTabs par2CreativeTabs, List<ItemStack> list) {
        if (!this.func_176552_j()) {
            for (Enum woodType : this.getVariant().func_177700_c()) {
                list.add(TreeManager.woodAccess.getStack((IWoodType)((Object)woodType), this.getBlockKind(), this.fireproof));
            }
        }
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        int meta = this.func_176201_c(blockState);
        T woodType = this.getWoodType(meta);
        return ((IWoodType)woodType).getHardness();
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.fireproof ? 0 : 20;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.fireproof ? 0 : 5;
    }

    @Override
    @Nonnull
    public WoodBlockKind getBlockKind() {
        return WoodBlockKind.SLAB;
    }

    public IProperty func_176551_l() {
        return this.getVariant();
    }

    public Comparable<?> func_185674_a(ItemStack stack) {
        return this.getWoodType(stack.func_77960_j());
    }

    @Nonnull
    public Collection<T> getWoodTypes() {
        return this.getVariant().func_177700_c();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerStateMapper() {
        String blockPath = this.func_176552_j() ? "double_slab" : this.getBlockKind().toString();
        Proxies.render.registerStateMapper((Block)this, new WoodTypeStateMapper(this, blockPath, this.getVariant()));
    }
}

