/*
 * Decompiled with CFR 0.152.
 */
package forestry.storage;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import forestry.api.genetics.ISpeciesRoot;
import forestry.api.storage.EnumBackpackType;
import forestry.api.storage.IBackpackDefinition;
import forestry.api.storage.IBackpackFilter;
import forestry.api.storage.IBackpackFilterConfigurable;
import forestry.api.storage.IBackpackInterface;
import forestry.core.utils.ItemStackUtil;
import forestry.storage.BackpackFilter;
import forestry.storage.BackpackFilterNaturalist;
import forestry.storage.items.ItemBackpack;
import forestry.storage.items.ItemBackpackNaturalist;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class BackpackInterface
implements IBackpackInterface {
    private final Map<String, IBackpackDefinition> definitions = new HashMap<String, IBackpackDefinition>();
    private final Multimap<String, String> backpackAcceptedItems = HashMultimap.create();

    public Multimap<String, String> getBackpackAcceptedItems() {
        return this.backpackAcceptedItems;
    }

    @Override
    public void addItemToForestryBackpack(@Nullable String backpackUid, @Nullable ItemStack itemStack) {
        if (backpackUid == null) {
            throw new NullPointerException("backpackUid must not be null");
        }
        if (itemStack == null) {
            throw new NullPointerException("itemStack must not be null");
        }
        if (itemStack.func_77973_b() == null) {
            throw new NullPointerException("itemStack.getItem() must not be null");
        }
        String stringForItemStack = ItemStackUtil.getStringForItemStack(itemStack);
        this.backpackAcceptedItems.put((Object)backpackUid, (Object)stringForItemStack);
    }

    @Override
    public void registerBackpackDefinition(@Nullable String backpackUid, @Nullable IBackpackDefinition definition) {
        if (backpackUid == null) {
            throw new NullPointerException("backpackUid must not be null");
        }
        if (definition == null) {
            throw new NullPointerException("definition must not be null");
        }
        this.definitions.put(backpackUid, definition);
    }

    @Override
    @Nullable
    public IBackpackDefinition getBackpackDefinition(@Nullable String backpackUid) {
        if (backpackUid == null) {
            throw new NullPointerException("backpackUid must not be null");
        }
        return this.definitions.get(backpackUid);
    }

    @Override
    @Nonnull
    public Item createBackpack(@Nullable String backpackUid, @Nullable EnumBackpackType type) {
        if (backpackUid == null) {
            throw new NullPointerException("backpackUid must not be null");
        }
        if (type == null) {
            throw new NullPointerException("type must not be null");
        }
        if (type == EnumBackpackType.NATURALIST) {
            throw new IllegalArgumentException("type must not be NATURALIST. Use createNaturalistBackpack instead.");
        }
        IBackpackDefinition definition = this.definitions.get(backpackUid);
        if (definition == null) {
            throw new IllegalArgumentException("No backpack definition was registered for UID: " + backpackUid);
        }
        return new ItemBackpack(definition, type);
    }

    @Override
    public Item createNaturalistBackpack(@Nullable String backpackUid, @Nullable ISpeciesRoot speciesRoot) {
        if (backpackUid == null) {
            throw new NullPointerException("backpackUid must not be null");
        }
        if (speciesRoot == null) {
            throw new NullPointerException("speciesRoot must not be null");
        }
        IBackpackDefinition definition = this.definitions.get(backpackUid);
        if (definition == null) {
            throw new IllegalArgumentException("No backpack definition was registered for UID: " + backpackUid);
        }
        return new ItemBackpackNaturalist(speciesRoot, definition);
    }

    @Override
    public IBackpackFilterConfigurable createBackpackFilter() {
        return new BackpackFilter();
    }

    @Override
    public IBackpackFilter createNaturalistBackpackFilter(String speciesRootUid) {
        return new BackpackFilterNaturalist(speciesRootUid);
    }
}

