/*
 * Decompiled with CFR 0.152.
 */
package forestry.storage;

import forestry.api.storage.BackpackManager;
import forestry.api.storage.IBackpackDefinition;
import forestry.api.storage.IBackpackFilter;
import forestry.core.utils.Translator;
import java.awt.Color;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class BackpackDefinition
implements IBackpackDefinition {
    private final int primaryColor;
    private final int secondaryColor;
    @Nonnull
    private final IBackpackFilter filter;

    public BackpackDefinition(@Nonnull Color primaryColor, @Nonnull Color secondaryColor) {
        this(primaryColor, secondaryColor, BackpackManager.backpackInterface.createBackpackFilter());
    }

    public BackpackDefinition(@Nonnull Color primaryColor, @Nonnull Color secondaryColor, @Nonnull IBackpackFilter filter) {
        this.primaryColor = primaryColor.getRGB();
        this.secondaryColor = secondaryColor.getRGB();
        this.filter = filter;
    }

    @Override
    @Nonnull
    public IBackpackFilter getFilter() {
        return this.filter;
    }

    @Override
    @Nonnull
    public String getName(ItemStack backpack) {
        NBTTagCompound nbt;
        Item item = backpack.func_77973_b();
        String display = Translator.translateToLocal(item.func_77657_g(backpack) + ".name").trim();
        NBTTagCompound tagCompound = backpack.func_77978_p();
        if (tagCompound != null && tagCompound.func_150297_b("display", 10) && (nbt = tagCompound.func_74775_l("display")).func_150297_b("Name", 8)) {
            display = nbt.func_74779_i("Name");
        }
        return display;
    }

    @Override
    public int getPrimaryColour() {
        return this.primaryColor;
    }

    @Override
    public int getSecondaryColour() {
        return this.secondaryColor;
    }
}

