/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes.jei.rainmaker;

import forestry.core.recipes.jei.ForestryRecipeCategory;
import forestry.factory.recipes.jei.rainmaker.RainmakerRecipeWrapper;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;

public class RainmakerRecipeCategory
extends ForestryRecipeCategory {
    private static final int SLOT_INPUT_INDEX = 0;
    private final IDrawable slot;

    public RainmakerRecipeCategory(@Nonnull IGuiHelper guiHelper) {
        super((IDrawable)guiHelper.createBlankDrawable(150, 30), "tile.for.rainmaker.name");
        this.slot = guiHelper.getSlotDrawable();
    }

    @Nonnull
    public String getUid() {
        return "forestry.rainmaker";
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        super.drawExtras(minecraft);
        this.slot.draw(minecraft);
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull IRecipeWrapper recipeWrapper) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 0, 0);
        if (recipeWrapper instanceof RainmakerRecipeWrapper) {
            RainmakerRecipeWrapper rainmakerRecipeWrapper = (RainmakerRecipeWrapper)recipeWrapper;
            List<ItemStack> input = rainmakerRecipeWrapper.getInputs().get(0);
            guiItemStacks.set(0, input);
        }
    }
}

