/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.gui.widgets;

import forestry.core.gui.tooltips.ToolTip;
import forestry.core.gui.widgets.Widget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.proxy.Proxies;
import forestry.core.render.TextureManager;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class HabitatSlot
extends Widget {
    @Nonnull
    private final Collection<BiomeDictionary.Type> biomes;
    @Nonnull
    private final String name;
    @Nonnull
    private final String iconIndex;
    public boolean isActive = false;

    public HabitatSlot(@Nonnull WidgetManager widgetManager, int xPos, int yPos, @Nonnull String name, @Nonnull Collection<BiomeDictionary.Type> biomes) {
        super(widgetManager, xPos, yPos);
        this.biomes = biomes;
        this.name = name;
        this.iconIndex = "habitats/" + name.toLowerCase(Locale.ENGLISH);
    }

    @Override
    public ToolTip getToolTip(int mouseX, int mouseY) {
        ToolTip tooltip = new ToolTip();
        tooltip.add(this.name);
        return tooltip;
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getIcon() {
        return TextureManager.getInstance().getDefault(this.iconIndex);
    }

    public void setActive(Collection<BiomeDictionary.Type> biomes) {
        this.isActive = !Collections.disjoint(this.biomes, biomes);
    }

    @Override
    public void draw(int startX, int startY) {
        if (this.getIcon() != null) {
            if (!this.isActive) {
                GlStateManager.func_179131_c((float)0.2f, (float)0.2f, (float)0.2f, (float)0.2f);
            } else {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            Proxies.render.bindTexture(TextureMap.field_110575_b);
            this.manager.gui.func_175175_a(startX + this.xPos, startY + this.yPos, this.getIcon(), 16, 16);
        }
    }
}

