/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.core.entities;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

import com.mojang.authlib.GameProfile;

import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.minecart.MinecartInteractEvent;

import forestry.core.access.AccessHandler;
import forestry.core.access.EnumAccess;
import forestry.core.access.IAccessHandler;
import forestry.core.access.IRestrictedAccess;
import forestry.core.gui.GuiHandler;
import forestry.core.gui.IGuiHandlerEntity;
import forestry.core.gui.IHintSource;
import forestry.core.tiles.ITitled;
import forestry.core.utils.Translator;

import net.minecraft.entity.item.EntityMinecart.Type;

public abstract class EntityMinecartForestry extends EntityMinecart implements ITitled, IRestrictedAccess, IHintSource, IGuiHandlerEntity {
	private final AccessHandler accessHandler = new AccessHandler(this);

	@SuppressWarnings("unused")
	public EntityMinecartForestry(World world) {
		super(world);
		func_94096_e(true);
	}

	public EntityMinecartForestry(World world, double posX, double posY, double posZ) {
		super(world, posX, posY, posZ);
		func_94096_e(true);
	}

	@Override
	public boolean func_184230_a(EntityPlayer player, ItemStack stack, EnumHand hand) {
		if (MinecraftForge.EVENT_BUS.post(new MinecartInteractEvent(this, player, stack, hand))) {
			return true;
		}

		if (!field_70170_p.field_72995_K) {
			GuiHandler.openGui(player, this);
		}
		return true;
	}

	public void setOwner(GameProfile owner) {
		accessHandler.setOwner(owner);
	}

	@Override
	public Type func_184264_v() {
		return null;
	}

	@Override
	protected void func_70037_a(NBTTagCompound nbtTagCompound) {
		super.func_70037_a(nbtTagCompound);
		accessHandler.readFromNBT(nbtTagCompound);
	}

	@Override
	protected void func_70014_b(NBTTagCompound nbtTagCompound) {
		super.func_70014_b(nbtTagCompound);
		accessHandler.writeToNBT(nbtTagCompound);
	}

	/* EntityMinecart */
	@Override
	public boolean canBeRidden() {
		return false;
	}
	
	@Override
	public boolean isPoweredCart() {
		return false;
	}

	// cart contents
	@Override
	public abstract IBlockState func_174897_t();

	// cart itemStack
	@Override
	public abstract ItemStack getCartItem();

	@Override
	public void func_94095_a(DamageSource damageSource) {
		super.func_94095_a(damageSource);
		if (this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
			Block block = func_174897_t().func_177230_c();
			func_70099_a(new ItemStack(block), 0.0F);
		}
	}

	// fix cart contents rendering as black in the End dimension
	@Override
	public float func_70013_c(float p_70013_1_) {
		return 1.0f;
	}

	@Override
	public String func_70005_c_() {
		return Translator.translateToLocal(getUnlocalizedTitle());
	}

	/* ITitled */
	@Override
	public String getUnlocalizedTitle() {
		ItemStack cartItem = getCartItem();
		return cartItem.func_77977_a() + ".name";
	}

	/* IRestrictedAccess */
	@Override
	public IAccessHandler getAccessHandler() {
		return accessHandler;
	}

	@Override
	public void onSwitchAccess(EnumAccess oldAccess, EnumAccess newAccess) {

	}
	
	@Override
	public int getIdOfEntity() {
		return func_145782_y();
	}
}
